/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.shrinkwrap.api.asset.Asset;

public class ConfigAnnotationAsset
implements Asset {
    private final Properties props = new Properties();

    public InputStream openStream() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.props.store(os, null);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error saving properties", e);
        }
    }

    public ConfigAnnotationAsset autoscaleMethod(Class<?> clazz, String method) {
        List methods = Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals(method)).collect(Collectors.toList());
        if (methods.size() == 0) {
            throw new RuntimeException("No such method " + method + " on class " + clazz.getName());
        }
        if (methods.size() > 1) {
            throw new RuntimeException("More than one method named " + method + " on class " + clazz.getName());
        }
        this.autoscaleElement(clazz, (Method)methods.get(0));
        return this;
    }

    public ConfigAnnotationAsset autoscaleClass(Class<?> clazz) {
        this.autoscaleElement(clazz, null);
        return this;
    }

    private void autoscaleElement(Class<?> clazz, Method method) {
        CircuitBreaker cb;
        Timeout timeout;
        GenericDeclaration element = clazz;
        String methodName = null;
        if (method != null) {
            element = method;
            methodName = method.getName();
        }
        TCKConfig config = TCKConfig.getConfig();
        Retry retry = element.getAnnotation(Retry.class);
        if (retry != null) {
            Duration maxDuration = Duration.of(retry.maxDuration(), retry.durationUnit());
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "maxDuration"), config.getTimeoutInStr(maxDuration.toMillis()));
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "maxDurationUnit"), ChronoUnit.MILLIS.name());
            Duration delay = Duration.of(retry.delay(), retry.delayUnit());
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "delay"), config.getTimeoutInStr(delay.toMillis()));
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "delayUnit"), ChronoUnit.MILLIS.name());
            Duration jitter = Duration.of(retry.jitter(), retry.jitterDelayUnit());
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "jitter"), config.getTimeoutInStr(jitter.toMillis()));
            this.props.put(this.keyFor(clazz, methodName, Retry.class, "jitterDelayUnit"), ChronoUnit.MILLIS.name());
        }
        if ((timeout = element.getAnnotation(Timeout.class)) != null) {
            Duration maxDuration = Duration.of(timeout.value(), timeout.unit());
            this.props.put(this.keyFor(clazz, methodName, Timeout.class, "value"), config.getTimeoutInStr(maxDuration.toMillis()));
            this.props.put(this.keyFor(clazz, methodName, Timeout.class, "unit"), ChronoUnit.MILLIS.name());
        }
        if ((cb = element.getAnnotation(CircuitBreaker.class)) != null) {
            Duration delay = Duration.of(cb.delay(), cb.delayUnit());
            this.props.put(this.keyFor(clazz, methodName, CircuitBreaker.class, "delay"), config.getTimeoutInStr(delay.toMillis()));
            this.props.put(this.keyFor(clazz, methodName, CircuitBreaker.class, "delayUnit"), ChronoUnit.MILLIS.name());
        }
    }

    public ConfigAnnotationAsset setValue(Class<?> clazz, String method, Class<? extends Annotation> annotation, String value) {
        this.props.put(this.keyFor(clazz, method, annotation, "value"), value);
        return this;
    }

    public ConfigAnnotationAsset set(Class<?> clazz, String method, Class<? extends Annotation> annotation, String parameter, String value) {
        this.props.put(this.keyFor(clazz, method, annotation, parameter), value);
        return this;
    }

    public ConfigAnnotationAsset setGlobally(Class<? extends Annotation> annotation, String parameter, String value) {
        this.props.put(this.keyFor(null, null, annotation, parameter), value);
        return this;
    }

    private String keyFor(Class<?> clazz, String method, Class<? extends Annotation> annotation, String property) {
        StringBuilder sb = new StringBuilder();
        if (clazz != null) {
            sb.append(clazz.getCanonicalName());
            sb.append("/");
        }
        if (method != null) {
            sb.append(method);
            sb.append("/");
        }
        sb.append(annotation.getSimpleName());
        sb.append("/");
        sb.append(property);
        return sb.toString();
    }

    public ConfigAnnotationAsset mergeProperties(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
        return this;
    }
}

