/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import jakarta.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.FallbackMetricHandler;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Fallback;

@ApplicationScoped
public class FallbackMetricBean {
    private Action fallbackAction = Action.PASS;

    @Fallback(fallbackMethod="doFallback", skipOn={NonFallbackException.class})
    public void doWork(Action action) {
        if (action == Action.PASS) {
            return;
        }
        if (action == Action.FAIL) {
            throw new TestException();
        }
        throw new NonFallbackException();
    }

    public void doFallback(Action action) {
        if (this.fallbackAction == Action.PASS) {
            return;
        }
        if (this.fallbackAction == Action.FAIL) {
            throw new TestException();
        }
        throw new NonFallbackException();
    }

    @Fallback(value=FallbackMetricHandler.class, applyOn={TestException.class})
    public Void doWorkWithHandler(Action action) {
        if (action == Action.PASS) {
            return null;
        }
        if (action == Action.FAIL) {
            throw new TestException();
        }
        throw new NonFallbackException();
    }

    public void setFallbackAction(Action action) {
        this.fallbackAction = action;
    }

    public Action getFallbackAction() {
        return this.fallbackAction;
    }

    public static class NonFallbackException
    extends RuntimeException {
        public NonFallbackException() {
            super("Non-fallback exception");
        }
    }

    public static enum Action {
        PASS,
        FAIL,
        NON_FALLBACK_EXCEPTION;

    }
}

