/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.timeout.clientserver.DefaultTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.timeout.clientserver.ShorterTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.timeout.clientserver.TimeoutClient;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimeoutTest
extends Arquillian {
    @Inject
    private TimeoutClient clientForTimeout;
    @Inject
    private DefaultTimeoutClient clientForDefaultTimeout;
    @Inject
    private ShorterTimeoutClient clientForShorterTimeout;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftTimeout.jar")).addClasses(new Class[]{TimeoutClient.class, DefaultTimeoutClient.class, ShorterTimeoutClient.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftTimeout.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testTimeout() {
        try {
            this.clientForTimeout.serviceA(20000L);
            Assert.fail((String)"serviceA should throw a TimeoutException in testTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceA should throw a TimeoutException in testTimeout not a RuntimeException");
        }
    }

    @Test
    public void testNoTimeout() {
        try {
            this.clientForTimeout.serviceA(10L);
            Assert.fail((String)"serviceB should throw a RuntimeException in testNoTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceB should throw a RuntimeException in testNoTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGTDefaultTimeout() {
        try {
            this.clientForTimeout.serviceB(2500L);
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTDefaultTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTDefaultTimeout not a RuntimeException");
        }
    }

    @Test
    public void testGTDefaultNoTimeout() {
        try {
            this.clientForTimeout.serviceB(1500L);
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTDefaultNoTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTDefaultNoTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLTDefaultTimeout() {
        try {
            this.clientForTimeout.serviceC(1000L);
            Assert.fail((String)"serviceC should throw a TimeoutException in testLTDefaultTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceC should throw a TimeoutException in testLTDefaultTimeout not a RuntimeException");
        }
    }

    @Test
    public void testLTDefaultNoTimeout() {
        try {
            this.clientForTimeout.serviceC(10L);
            Assert.fail((String)"serviceC should throw a RuntimeException in testLTDefaultNoTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceC should throw a RuntimeException in testLTDefaultNoTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSecondsTimeout() {
        try {
            this.clientForTimeout.serviceD(2500L);
            Assert.fail((String)"serviceD should throw a TimeoutException in testSecondsTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceD should throw a TimeoutException in testSecondsTimeout not a RuntimeException");
        }
    }

    @Test
    public void testSecondsNoTimeout() {
        try {
            this.clientForTimeout.serviceD(1500L);
            Assert.fail((String)"serviceD should throw a RuntimeException in testSecondsNoTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceD should throw a RuntimeException in testSecondsNoTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeoutClassLevel() {
        try {
            this.clientForDefaultTimeout.serviceA(20000L);
            Assert.fail((String)"serviceA should throw a TimeoutException in testTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceA should throw a TimeoutException in testTimeout not a RuntimeException");
        }
    }

    @Test
    public void testNoTimeoutClassLevel() {
        try {
            this.clientForDefaultTimeout.serviceA(10L);
            Assert.fail((String)"serviceB should throw a RuntimeException in testNoTimeoutClassLevel");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceB should throw a RuntimeException in testNoTimeoutClassLevel not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGTDefaultTimeoutOverride() {
        try {
            this.clientForDefaultTimeout.serviceB(2500L);
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTDefaultTimeout");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTDefaultTimeout not a RuntimeException");
        }
    }

    @Test
    public void testGTDefaultNoTimeoutOverride() {
        try {
            this.clientForDefaultTimeout.serviceB(1500L);
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTDefaultNoTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTDefaultNoTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLTDefaultTimeoutClassLevel() {
        try {
            this.clientForShorterTimeout.serviceA(1000L);
            Assert.fail((String)"serviceA should throw a TimeoutException in testLTDefaultTimeoutClassLevel");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceA should throw a TimeoutException in testLTDefaultTimeoutClassLevel not a RuntimeException");
        }
    }

    @Test
    public void testLTDefaultNoTimeoutClassLevel() {
        try {
            this.clientForShorterTimeout.serviceA(10L);
            Assert.fail((String)"serviceA should throw a RuntimeException in testLTDefaultNoTimeoutClassLevel");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceA should throw a RuntimeException in testLTDefaultNoTimeoutClassLevel not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGTShorterTimeoutOverride() {
        try {
            this.clientForShorterTimeout.serviceB(2500L);
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTShorterTimeoutOverride");
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceB should throw a TimeoutException in testGTShorterTimeoutOverride not a RuntimeException");
        }
    }

    @Test
    public void testGTShorterNoTimeoutOverride() {
        try {
            this.clientForShorterTimeout.serviceB(1500L);
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTShorterNoTimeoutOverride");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceB should throw a RuntimeException in testGTShorterNoTimeoutOverride not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

