/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling;

import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.interceptor.OrderQueueProducer;
import org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling.EarlyFtInterceptor;
import org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling.InterceptorComponent;
import org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling.LateFtInterceptor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class FaultToleranceInterceptorEnableByXmlTest
extends Arquillian {
    @Inject
    private InterceptorComponent testInterceptor;
    @Inject
    private OrderQueueProducer orderFactory;

    @Deployment
    public static WebArchive deploy() {
        BeansDescriptor beans = (BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{"org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling.EarlyFtInterceptor"}).up()).getOrCreateInterceptors().clazz(new String[]{"org.eclipse.microprofile.fault.tolerance.tck.interceptor.xmlInterceptorEnabling.LateFtInterceptor"}).up();
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"interceptorFtXml.jar")).addClasses(new Class[]{InterceptorComponent.class, EarlyFtInterceptor.class, LateFtInterceptor.class, OrderQueueProducer.class})).addAsManifestResource((Asset)new StringAsset(beans.exportAsString()), "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"interceptorFtXml.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testAsync() throws InterruptedException, ExecutionException {
        Future<String> result = this.testInterceptor.asyncGetString();
        Assert.assertEquals((String)result.get(), (String)"OK");
        Object[] expectedOrder = new String[]{"EarlyOrderFtInterceptor", "LateOrderFtInterceptor", "asyncGetString"};
        Assert.assertEquals((Object[])this.orderFactory.getOrderQueue().toArray(), (Object[])expectedOrder);
    }

    @Test
    public void testRetryInterceptors() {
        try {
            this.testInterceptor.serviceRetryA();
            Assert.fail((String)"Exception not thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage().trim(), (String)"retryGetString failed");
        }
        Object[] expectedOrder = new String[]{"EarlyOrderFtInterceptor", "LateOrderFtInterceptor", "serviceRetryA", "EarlyOrderFtInterceptor", "LateOrderFtInterceptor", "serviceRetryA"};
        Assert.assertEquals((Object[])this.orderFactory.getOrderQueue().toArray(), (Object[])expectedOrder);
    }

    @AfterMethod
    public void clearResources() {
        if (this.orderFactory != null) {
            this.orderFactory.getOrderQueue().clear();
        }
    }
}

