/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncApplicationScopeClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClassLevelClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncRequestScopeClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class AsynchronousTest
extends Arquillian {
    @Inject
    private AsyncClient client;
    @Inject
    private AsyncClassLevelClient clientClass;
    @Inject
    private AsyncApplicationScopeClient clientApplicationScope;
    private List<CompletableFuture<Void>> waitingFutures = new ArrayList<CompletableFuture<Void>>();

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsynchronous.jar")).addClasses(new Class[]{AsyncClient.class, AsyncClassLevelClient.class, AsyncApplicationScopeClient.class, AsyncRequestScopeClient.class, Connection.class, CompletableFutureHelper.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsynchronous.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testAsyncIsNotFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Connection> future = this.client.service(waitingFuture);
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testAsyncIsFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Connection> future = this.client.service(waitingFuture);
        waitingFuture.complete(null);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertTrue((boolean)future.isDone()));
    }

    @Test
    public void testClassLevelAsyncIsNotFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Connection> future = this.clientClass.service(waitingFuture);
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testClassLevelAsyncIsFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Connection> future = this.clientClass.service(waitingFuture);
        waitingFuture.complete(null);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertTrue((boolean)future.isDone()));
    }

    @Test
    public void testAsyncRequestContextWithCompletionStage() throws InterruptedException, ExecutionException, TimeoutException {
        CompletionStage<String> completionStage = this.clientApplicationScope.serviceCallingCompletionStageMethod();
        String result = CompletableFutureHelper.toCompletableFuture(completionStage).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((String)result, (String)"testCompletionStageString");
    }

    @Test
    public void testAsyncRequestContextWithFuture() throws InterruptedException, ExecutionException, TimeoutException {
        Future<String> future = this.clientApplicationScope.serviceCallingFutureMethod();
        String result = future.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((String)result, (String)"testFutureString");
    }

    private CompletableFuture<Void> newWaitingFuture() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.waitingFutures.add(result);
        return result;
    }

    @AfterMethod
    public void completeWaitingFutures() {
        this.waitingFutures.forEach(future -> future.complete(null));
        this.waitingFutures.clear();
    }
}

