/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import java.util.Optional;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class GaugeMetric {
    private MetricRegistry registry;
    private MetricID metricId;
    private long baseline;

    public GaugeMetric(MetricRegistry registry, MetricID metricId) {
        this.registry = registry;
        this.metricId = metricId;
        this.baseline = 0L;
    }

    public long value() {
        return this.gauge().map(Gauge::getValue).orElse(0L);
    }

    public void baseline() {
        this.baseline = this.value();
    }

    public long delta() {
        return this.value() - this.baseline;
    }

    public Optional<Gauge<Long>> gauge() {
        Gauge gauge = (Gauge)this.registry.getGauges().get(this.metricId);
        if (gauge == null) {
            return Optional.empty();
        }
        MatcherAssert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.instanceOf(Long.class));
        return Optional.of(gauge);
    }
}

