/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import java.util.Optional;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class CounterMetric {
    private MetricRegistry registry;
    private MetricID metricId;
    private long baseline;

    public CounterMetric(MetricRegistry registry, MetricID metricId) {
        this.registry = registry;
        this.metricId = metricId;
        this.baseline = 0L;
    }

    public long value() {
        return this.counter().map(Counter::getCount).orElse(0L);
    }

    public void baseline() {
        this.baseline = this.value();
    }

    public long delta() {
        return this.value() - this.baseline;
    }

    public Optional<Counter> counter() {
        return Optional.ofNullable(this.registry.getCounters().get(this.metricId));
    }
}

