/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.CircuitBreakerMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CircuitBreakerMetricTest
extends Arquillian {
    private static final long CB_CLOSE_TIMEOUT = TCKConfig.getConfig().getTimeoutInDuration(5000).toNanos();
    @Inject
    private CircuitBreakerMetricBean cbBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(CircuitBreakerMetricBean.class, "doWork");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricCircuitBreaker.jar")).addClasses(new Class[]{CircuitBreakerMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricCircuitBreaker.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @BeforeTest
    public void closeTheCircuit() throws Exception {
        if (this.cbBean != null) {
            boolean circuitOpen = true;
            long startTime = System.nanoTime();
            while (circuitOpen && System.nanoTime() - startTime < CB_CLOSE_TIMEOUT) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS);
                    }
                    circuitOpen = false;
                }
                catch (CircuitBreakerOpenException e) {
                    Thread.sleep(100L);
                }
            }
            if (circuitOpen) {
                throw new RuntimeException("Timed out waiting for circuit breaker to close");
            }
        }
    }

    @Test
    public void testCircuitBreakerMetric() throws Exception {
        MetricGetter m = new MetricGetter(CircuitBreakerMetricBean.class, "doWork");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.FAIL));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)0L));
        Exceptions.expectTestException(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.FAIL));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expectCbOpen(() -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(1500L));
        for (int i = 0; i < 2; ++i) {
            this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS);
        }
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expect(RuntimeException.class, () -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.PASS_EXCEPTION));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        Exceptions.expect(CircuitBreakerMetricBean.SkippedException.class, () -> this.cbBean.doWork(CircuitBreakerMetricBean.Result.SKIPPED_EXCEPTION));
        MatcherAssert.assertThat((String)"circuitbreaker calls succeeded", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"circuitbreaker calls failed", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"circuitbreaker calls prevented", (Object)m.getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuit breaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)5L));
    }
}

