/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.TimeoutMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricComparator;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class TimeoutMetricTest
extends Arquillian {
    @Inject
    private TimeoutMetricBean timeoutBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().setValue(TimeoutMetricBean.class, "counterTestWorkForMillis", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(500L)).setValue(TimeoutMetricBean.class, "histogramTestWorkForMillis", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(2000L));
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricTimeout.jar")).addClasses(new Class[]{TimeoutMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricTimeout.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testTimeoutMetric() {
        MetricGetter m = new MetricGetter(TimeoutMetricBean.class, "counterTestWorkForMillis");
        m.baselineCounters();
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(2000L)));
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(2000L)));
        this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(100L));
        MatcherAssert.assertThat((String)"calls timed out", (Object)m.getTimeoutCallsTimedOutDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"calls not timed out", (Object)m.getTimeoutCallsNotTimedOutDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testTimeoutHistogram() {
        MetricGetter m = new MetricGetter(TimeoutMetricBean.class, "histogramTestWorkForMillis");
        this.timeoutBean.histogramTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(300L));
        Exceptions.expectTimeout(() -> this.timeoutBean.histogramTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(5000L)));
        Histogram histogram = m.getTimeoutExecutionDuration().get();
        Snapshot snapshot = histogram.getSnapshot();
        List values = Arrays.stream(snapshot.getValues()).boxed().sorted().collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Histogram count", (Object)histogram.getCount(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"SnapshotValues", values, (Matcher)Matchers.contains((Matcher[])new Matcher[]{MetricComparator.approxMillis(300L), MetricComparator.approxMillis(2000L)}));
    }
}

