/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2S;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.exception.hierarchy.FallbackService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FallbackExceptionHierarchyTest
extends Arquillian {
    @Inject
    private Instance<FallbackService> serviceInstance;
    private FallbackService service;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftFallbackExceptionHierarchy.jar")).addPackage(E0.class.getPackage())).addClass(FallbackService.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftFallbackExceptionHierarchy.war")).addAsLibrary((Archive)jar);
    }

    @BeforeMethod
    public void setup() {
        if (this.serviceInstance != null) {
            this.service = (FallbackService)this.serviceInstance.get();
        }
    }

    @AfterMethod
    public void teardown() {
        if (this.serviceInstance != null) {
            this.serviceInstance.destroy((Object)this.service);
        }
    }

    @Test
    public void serviceAthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Exception())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0())), (Object)((Object)FallbackStatus.FALLBACK));
    }

    @Test
    public void serviceAthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0S())), (Object)((Object)FallbackStatus.FALLBACK));
    }

    @Test
    public void serviceAthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new RuntimeException())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceAthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    private FallbackStatus invokeServiceA(Throwable exception) {
        try {
            String result = this.service.serviceA(exception);
            if (this.service.getFallbackValue().equals(result)) {
                return FallbackStatus.FALLBACK;
            }
            return FallbackStatus.NOFALLBACK;
        }
        catch (Throwable ex) {
            return FallbackStatus.NOFALLBACK;
        }
    }

    @Test
    public void serviceBthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new Exception())), (Object)((Object)FallbackStatus.FALLBACK));
    }

    @Test
    public void serviceBthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceBthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new RuntimeException())), (Object)((Object)FallbackStatus.FALLBACK));
    }

    @Test
    public void serviceBthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    private FallbackStatus invokeserviceB(Throwable exception) {
        try {
            String result = this.service.serviceB(exception);
            if (this.service.getFallbackValue().equals(result)) {
                return FallbackStatus.FALLBACK;
            }
            return FallbackStatus.NOFALLBACK;
        }
        catch (Throwable ex) {
            return FallbackStatus.NOFALLBACK;
        }
    }

    @Test
    public void serviceCthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Exception())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0S())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new RuntimeException())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    @Test
    public void serviceCthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Error())), (Object)((Object)FallbackStatus.NOFALLBACK));
    }

    private FallbackStatus invokeServiceC(Throwable exception) {
        try {
            String result = this.service.serviceC(exception);
            if (this.service.getFallbackValue().equals(result)) {
                return FallbackStatus.FALLBACK;
            }
            return FallbackStatus.NOFALLBACK;
        }
        catch (Throwable ex) {
            return FallbackStatus.NOFALLBACK;
        }
    }

    private static enum FallbackStatus {
        FALLBACK,
        NOFALLBACK;

    }
}

