/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AsyncBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithAsyncBulkhead;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithAsyncBulkheadNoFail;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithSyncBulkhead;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerBulkheadTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithAsyncBulkhead asyncBulkheadClient;
    @Inject
    private CircuitBreakerClientWithSyncBulkhead syncBulkheadClient;
    @Inject
    private CircuitBreakerClientWithAsyncBulkheadNoFail asyncBulkheadNoFailClient;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerBulkhead.jar")).addClasses(new Class[]{CircuitBreakerClientWithAsyncBulkhead.class, CircuitBreakerClientWithSyncBulkhead.class, CircuitBreakerClientWithAsyncBulkheadNoFail.class})).addPackage(BulkheadTask.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerBulkhead.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitBreakerAroundBulkheadAsync() throws InterruptedException, ExecutionException, TimeoutException {
        Future resulti;
        AsyncBulkheadTask taski;
        int i;
        AsyncBulkheadTask task1 = new AsyncBulkheadTask();
        Future result1 = this.asyncBulkheadClient.test(task1);
        task1.assertStarting(result1);
        AsyncBulkheadTask task2 = new AsyncBulkheadTask();
        Future result2 = this.asyncBulkheadClient.test(task2);
        task2.assertNotStarting();
        for (i = 3; i < 6; ++i) {
            taski = new AsyncBulkheadTask();
            resulti = this.asyncBulkheadClient.test(taski);
            Exceptions.expect(BulkheadException.class, resulti);
        }
        for (i = 6; i < 8; ++i) {
            taski = new AsyncBulkheadTask();
            resulti = this.asyncBulkheadClient.test(taski);
            Exceptions.expect(CircuitBreakerOpenException.class, resulti);
        }
        task1.complete(CompletableFuture.completedFuture("OK"));
        task2.complete(CompletableFuture.completedFuture("OK"));
        task2.assertStarting(result2);
        Assert.assertEquals(result1.get(2L, TimeUnit.SECONDS), (Object)"OK");
        Assert.assertEquals(result2.get(2L, TimeUnit.SECONDS), (Object)"OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCircuitBreakerAroundBulkheadSync() throws InterruptedException, ExecutionException, TimeoutException {
        BulkheadTaskManager manager = new BulkheadTaskManager();
        try {
            BulkheadTask taski;
            int i;
            BulkheadTask task1 = manager.startTask(this.syncBulkheadClient);
            task1.assertStarting();
            for (i = 2; i < 5; ++i) {
                taski = manager.startTask(this.syncBulkheadClient);
                taski.assertFinishing();
                Exceptions.expect(BulkheadException.class, taski.getResultFuture());
            }
            for (i = 5; i < 7; ++i) {
                taski = manager.startTask(this.syncBulkheadClient);
                taski.assertFinishing();
                Exceptions.expect(CircuitBreakerOpenException.class, taski.getResultFuture());
            }
            task1.complete(CompletableFuture.completedFuture("OK"));
            task1.assertFinishing();
            Assert.assertEquals(task1.getResult().get(2L, TimeUnit.MINUTES), (Object)"OK");
        }
        finally {
            manager.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCircuitBreaker() throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<AsyncBulkheadTask> tasks = new ArrayList<AsyncBulkheadTask>();
        try {
            AsyncBulkheadTask task1 = new AsyncBulkheadTask();
            tasks.add(task1);
            Future result1 = this.asyncBulkheadNoFailClient.test(task1);
            task1.assertStarting(result1);
            AsyncBulkheadTask task2 = new AsyncBulkheadTask();
            tasks.add(task2);
            Future result2 = this.asyncBulkheadNoFailClient.test(task2);
            task2.assertNotStarting();
            for (int i = 3; i < 8; ++i) {
                AsyncBulkheadTask taski = new AsyncBulkheadTask();
                tasks.add(taski);
                Future resulti = this.asyncBulkheadNoFailClient.test(taski);
                Exceptions.expect(BulkheadException.class, resulti);
            }
            task1.complete(CompletableFuture.completedFuture("OK"));
            task2.complete(CompletableFuture.completedFuture("OK"));
            task2.assertStarting(result2);
            Assert.assertEquals(result1.get(2L, TimeUnit.SECONDS), (Object)"OK");
            Assert.assertEquals(result2.get(2L, TimeUnit.SECONDS), (Object)"OK");
        }
        finally {
            for (AsyncBulkheadTask task : tasks) {
                task.complete();
            }
        }
    }
}

