/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class MetricGetter {
    private static boolean isMetrics20;
    private static Class<?> metricIdClass;
    private String prefix;
    private MetricRegistry registry;
    private long invocationsBaseline;
    private long invocationsFailedBaseline;
    private long retryCallsSucceededNotRetriedBaseline;
    private long retryCallsSucceededRetriedBaseline;
    private long retryCallsFailedBaseline;
    private long retryRetriesBaseline;
    private long timeoutCallsTimedOutBaseline;
    private long timeoutCallsNotTimedOutBaseline;
    private long circuitBreakerCallsSucceededBaseline;
    private long circuitBreakerCallsFailedBaseline;
    private long circuitBreakerCallsPreventedBaseline;
    private long circuitBreakerTimeOpenBaseline;
    private long circuitBreakerTimeHalfOpenBaseline;
    private long circuitBreakerTimeClosedBaseline;
    private long circuitBreakerOpenedBaseline;
    private long bulkheadCallsAcceptedBaseline;
    private long bulkheadCallsRejectedBaseline;
    private long fallbackCallsBaseline;

    public MetricGetter(Class<?> clazz, String methodName) {
        this.validateClassAndMethodName(clazz, methodName);
        this.prefix = "ft." + clazz.getCanonicalName() + "." + methodName;
        this.registry = (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[0]).get();
    }

    public void baselineCounters() {
        this.invocationsBaseline = this.getInvocationsTotal();
        this.invocationsFailedBaseline = this.getInvocationsFailedTotal();
        this.retryCallsSucceededNotRetriedBaseline = this.getRetryCallsSucceededNotRetriedTotal();
        this.retryCallsSucceededRetriedBaseline = this.getRetryCallsSucceededRetriedTotal();
        this.retryCallsFailedBaseline = this.getRetryCallsFailedTotal();
        this.retryRetriesBaseline = this.getRetryRetriesTotal();
        this.timeoutCallsTimedOutBaseline = this.getTimeoutCallsTimedOutTotal();
        this.timeoutCallsNotTimedOutBaseline = this.getTimeoutCallsNotTimedOutTotal();
        this.circuitBreakerCallsSucceededBaseline = this.getCircuitBreakerCallsSucceededTotal();
        this.circuitBreakerCallsFailedBaseline = this.getCircuitBreakerCallsFailedTotal();
        this.circuitBreakerCallsPreventedBaseline = this.getCircuitBreakerCallsPreventedTotal();
        this.circuitBreakerTimeOpenBaseline = this.getCircuitBreakerTimeOpenTotal();
        this.circuitBreakerTimeHalfOpenBaseline = this.getCircuitBreakerTimeHalfOpenTotal();
        this.circuitBreakerTimeClosedBaseline = this.getCircuitBreakerTimeClosedTotal();
        this.circuitBreakerOpenedBaseline = this.getCircuitBreakerOpenedTotal();
        this.bulkheadCallsAcceptedBaseline = this.getBulkheadCallsAcceptedTotal();
        this.bulkheadCallsRejectedBaseline = this.getBulkheadCallsRejectedTotal();
        this.fallbackCallsBaseline = this.getFallbackCallsTotal();
    }

    public long getInvocationsTotal() {
        return this.getCounterValue(this.prefix + ".invocations.total");
    }

    public long getInvocationsDelta() {
        return this.getInvocationsTotal() - this.invocationsBaseline;
    }

    public long getInvocationsFailedTotal() {
        return this.getCounterValue(this.prefix + ".invocations.failed.total");
    }

    public long getInvocationsFailedDelta() {
        return this.getInvocationsFailedTotal() - this.invocationsFailedBaseline;
    }

    public long getRetryCallsSucceededNotRetriedTotal() {
        return this.getCounterValue(this.prefix + ".retry.callsSucceededNotRetried.total");
    }

    public long getRetryCallsSucceededNotRetriedDelta() {
        return this.getRetryCallsSucceededNotRetriedTotal() - this.retryCallsSucceededNotRetriedBaseline;
    }

    public long getRetryCallsSucceededRetriedTotal() {
        return this.getCounterValue(this.prefix + ".retry.callsSucceededRetried.total");
    }

    public long getRetryCallsSucceededRetriedDelta() {
        return this.getRetryCallsSucceededRetriedTotal() - this.retryCallsSucceededRetriedBaseline;
    }

    public long getRetryCallsFailedTotal() {
        return this.getCounterValue(this.prefix + ".retry.callsFailed.total");
    }

    public long getRetryCallsFailedDelta() {
        return this.getRetryCallsFailedTotal() - this.retryCallsFailedBaseline;
    }

    public long getRetryRetriesTotal() {
        return this.getCounterValue(this.prefix + ".retry.retries.total");
    }

    public long getRetryRetriesDelta() {
        return this.getRetryRetriesTotal() - this.retryRetriesBaseline;
    }

    public Optional<Histogram> getTimeoutExecutionDuration() {
        return this.getMetric(this.prefix + ".timeout.executionDuration", Histogram.class);
    }

    public long getTimeoutCallsTimedOutTotal() {
        return this.getCounterValue(this.prefix + ".timeout.callsTimedOut.total");
    }

    public long getTimeoutCallsTimedOutDelta() {
        return this.getTimeoutCallsTimedOutTotal() - this.timeoutCallsTimedOutBaseline;
    }

    public long getTimeoutCallsNotTimedOutTotal() {
        return this.getCounterValue(this.prefix + ".timeout.callsNotTimedOut.total");
    }

    public long getTimeoutCallsNotTimedOutDelta() {
        return this.getTimeoutCallsNotTimedOutTotal() - this.timeoutCallsNotTimedOutBaseline;
    }

    public long getCircuitBreakerCallsSucceededTotal() {
        return this.getCounterValue(this.prefix + ".circuitbreaker.callsSucceeded.total");
    }

    public long getCircuitBreakerCallsSucceededDelta() {
        return this.getCircuitBreakerCallsSucceededTotal() - this.circuitBreakerCallsSucceededBaseline;
    }

    public long getCircuitBreakerCallsFailedTotal() {
        return this.getCounterValue(this.prefix + ".circuitbreaker.callsFailed.total");
    }

    public long getCircuitBreakerCallsFailedDelta() {
        return this.getCircuitBreakerCallsFailedTotal() - this.circuitBreakerCallsFailedBaseline;
    }

    public long getCircuitBreakerCallsPreventedTotal() {
        return this.getCounterValue(this.prefix + ".circuitbreaker.callsPrevented.total");
    }

    public long getCircuitBreakerCallsPreventedDelta() {
        return this.getCircuitBreakerCallsPreventedTotal() - this.circuitBreakerCallsPreventedBaseline;
    }

    public long getCircuitBreakerTimeOpenTotal() {
        return this.getGaugeValue(this.prefix + ".circuitbreaker.open.total", Long.class).orElse(0L);
    }

    public long getCircuitBreakerTimeOpenDelta() {
        return this.getCircuitBreakerTimeOpenTotal() - this.circuitBreakerTimeOpenBaseline;
    }

    public long getCircuitBreakerTimeHalfOpenTotal() {
        return this.getGaugeValue(this.prefix + ".circuitbreaker.halfOpen.total", Long.class).orElse(0L);
    }

    public long getCircuitBreakerTimeHalfOpenDelta() {
        return this.getCircuitBreakerTimeHalfOpenTotal() - this.circuitBreakerTimeHalfOpenBaseline;
    }

    public long getCircuitBreakerTimeClosedTotal() {
        return this.getGaugeValue(this.prefix + ".circuitbreaker.closed.total", Long.class).orElse(0L);
    }

    public long getCircuitBreakerTimeClosedDelta() {
        return this.getCircuitBreakerTimeClosedTotal() - this.circuitBreakerTimeClosedBaseline;
    }

    public long getCircuitBreakerOpenedTotal() {
        return this.getCounterValue(this.prefix + ".circuitbreaker.opened.total");
    }

    public long getCircuitBreakerOpenedDelta() {
        return this.getCircuitBreakerOpenedTotal() - this.circuitBreakerOpenedBaseline;
    }

    public Optional<Long> getBulkheadConcurrentExecutions() {
        return this.getGaugeValue(this.prefix + ".bulkhead.concurrentExecutions", Long.class);
    }

    public long getBulkheadCallsAcceptedTotal() {
        return this.getCounterValue(this.prefix + ".bulkhead.callsAccepted.total");
    }

    public long getBulkheadCallsAcceptedDelta() {
        return this.getBulkheadCallsAcceptedTotal() - this.bulkheadCallsAcceptedBaseline;
    }

    public long getBulkheadCallsRejectedTotal() {
        return this.getCounterValue(this.prefix + ".bulkhead.callsRejected.total");
    }

    public long getBulkheadCallsRejectedDelta() {
        return this.getBulkheadCallsRejectedTotal() - this.bulkheadCallsRejectedBaseline;
    }

    public Optional<Histogram> getBulkheadExecutionDuration() {
        return this.getMetric(this.prefix + ".bulkhead.executionDuration", Histogram.class);
    }

    public Optional<Long> getBulkheadQueuePopulation() {
        return this.getGaugeValue(this.prefix + ".bulkhead.waitingQueue.population", Long.class);
    }

    public Optional<Histogram> getBulkheadWaitTime() {
        return this.getMetric(this.prefix + ".bulkhead.waiting.duration", Histogram.class);
    }

    public long getFallbackCallsTotal() {
        return this.getCounterValue(this.prefix + ".fallback.calls.total");
    }

    public long getFallbackCallsDelta() {
        return this.getFallbackCallsTotal() - this.fallbackCallsBaseline;
    }

    private long getCounterValue(String name) {
        return this.getMetric(name, Counter.class).map(Counter::getCount).orElse(0L);
    }

    private <T> Optional<T> getGaugeValue(String name, Class<T> resultType) {
        return this.getMetric(name, Gauge.class).map(g -> resultType.cast(g.getValue()));
    }

    private <T> Optional<T> getMetric(String name, Class<T> metricType) {
        String key;
        if (isMetrics20) {
            try {
                key = metricIdClass.getConstructor(String.class).newInstance(name);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            key = name;
        }
        Metric m = (Metric)this.registry.getMetrics().get(key);
        if (m != null) {
            MatcherAssert.assertThat((String)("Metric " + name), (Object)m, (Matcher)Matchers.instanceOf(metricType));
            return Optional.of(metricType.cast(m));
        }
        return Optional.empty();
    }

    private void validateClassAndMethodName(Class<?> clazz, String methodName) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return;
        }
        Assert.fail((String)("Couldn't find method " + methodName + " on class " + clazz.getCanonicalName()));
    }

    static {
        try {
            metricIdClass = Class.forName("org.eclipse.microprofile.metrics.MetricID");
            isMetrics20 = true;
        }
        catch (ClassNotFoundException e) {
            isMetrics20 = false;
        }
    }
}

