/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.asynchronous;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

@RequestScoped
public class AsyncClient {
    @Asynchronous
    public Future<Connection> service(Future<?> waitCondition) {
        return CompletableFutureHelper.toCompletableFuture(this.serviceCS(waitCondition, false));
    }

    @Asynchronous
    public CompletionStage<Connection> serviceCS(Future<?> waitCondition, boolean throwException) {
        return this.serviceCS(waitCondition, false, null);
    }

    @Asynchronous
    public CompletionStage<Connection> serviceCS(Future<?> waitCondition) {
        return this.serviceCS(waitCondition, false);
    }

    @Asynchronous
    public CompletionStage<Connection> serviceCS(Future<?> waitCondition, CompletionStage<Connection> stageToReturn) {
        return this.serviceCS(waitCondition, false, stageToReturn);
    }

    private CompletionStage<Connection> serviceCS(Future<?> waitCondition, boolean throwException, CompletionStage<Connection> stageToReturn) {
        Throwable exception = null;
        try {
            waitCondition.get(1000L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        catch (InterruptedException | TimeoutException e) {
            exception = e;
        }
        if (exception != null) {
            if (throwException) {
                this.throwAsRuntimeException(exception);
            } else {
                return CompletableFutureHelper.failedFuture(exception);
            }
        }
        if (stageToReturn != null) {
            return stageToReturn;
        }
        return CompletableFuture.completedFuture(new Connection(){

            @Override
            public String getData() {
                return "service DATA";
            }
        });
    }

    private void throwAsRuntimeException(Throwable exception) throws RuntimeException {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }
}

