/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.FutureChecker;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadFutureTest
extends Arquillian {
    private static final int SHORT_TIME = 100;
    @Inject
    private BulkheadMethodAsynchronousDefaultBean bhBeanMethodAsynchronousDefault;
    @Inject
    private BulkheadClassAsynchronousDefaultBean bhBeanClassAsynchronousDefault;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadFutureTest.jar")).addPackage(FutureChecker.class.getPackage())).addClass(Utils.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadTest.war")).addAsLibrary((Archive)testJar);
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneAfterGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanMethodAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            Assert.assertEquals((String)((String)result.get()), (String)"RESULT");
            Assert.assertEquals((String)((String)result.get(1L, TimeUnit.SECONDS)), (String)"RESULT");
        }
        catch (Throwable t) {
            Assert.fail((String)"Unexpected exception", (Throwable)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneWithoutGet() {
        FutureChecker fc = new FutureChecker(100);
        try {
            Future result = this.bhBeanMethodAsynchronousDefault.test(fc);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            Awaitility.await().atMost(10000L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assert.assertTrue((boolean)result.isDone()));
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneAfterGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanClassAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            Assert.assertEquals((String)((String)result.get(1L, TimeUnit.SECONDS)), (String)"RESULT");
            Assert.assertEquals((String)((String)result.get()), (String)"RESULT");
        }
        catch (Throwable t) {
            Assert.fail((String)"Unexpected exception", (Throwable)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneWithoutGet() {
        FutureChecker fc = new FutureChecker(100);
        try {
            Future result = this.bhBeanClassAsynchronousDefault.test(fc);
            Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
            Awaitility.await().atMost(10000L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assert.assertTrue((boolean)result.isDone()));
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
    }
}

