/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;

public class FutureChecker
extends Checker {
    public FutureChecker(int sleepMillis, TestData td) {
        super(sleepMillis, td);
    }

    public FutureChecker(int sleepMillis) {
        super(sleepMillis, new TestData());
    }

    @Override
    public Future<String> perform() throws InterruptedException {
        block4: {
            try {
                int left = this.getSleep();
                int tick = 250;
                while (left > 0 && !Thread.currentThread().isInterrupted()) {
                    if (left < tick) {
                        Utils.log("tick(" + left + "),");
                        Utils.sleep(left);
                        left = 0;
                        continue;
                    }
                    Utils.log("tick(" + left + "),");
                    Thread.sleep(tick);
                    left -= tick;
                }
            }
            catch (InterruptedException e) {
                Utils.log("FutureChecker interrupted " + e.toString());
                if (this.getSleep() <= 60000) break block4;
                throw e;
            }
        }
        return new TestFuture();
    }

    public final class TestFuture
    implements Future<String> {
        private boolean isCancelled;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public String get() {
            return "RESULT";
        }

        @Override
        public String get(long timeout, TimeUnit unit) {
            return "RESULT";
        }
    }
}

