/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.BulkheadMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricComparator;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BulkheadMetricTest
extends Arquillian {
    @Inject
    private BulkheadMetricBean bulkheadBean;
    @Inject
    private AsyncCaller async;
    private TCKConfig config = TCKConfig.getConfig();
    private List<CompletableFuture<Void>> waitingFutures = new ArrayList<CompletableFuture<Void>>();

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricBulkhead.war")).addClasses(new Class[]{BulkheadMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @AfterMethod
    public void completeWaitingFutures() {
        for (CompletableFuture<Void> future : this.waitingFutures) {
            future.complete(null);
        }
        this.waitingFutures.clear();
    }

    private CompletableFuture<Void> newWaitingFuture() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.waitingFutures.add(result);
        return result;
    }

    @Test
    public void bulkheadMetricTest() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(BulkheadMetricBean.class, "waitFor");
        m.baselineCounters();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        this.bulkheadBean.waitForRunningExecutions(2);
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)2L));
        waitingFuture.complete(null);
        f1.get();
        f2.get();
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCallsAcceptedDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"rejected calls", (Object)m.getBulkheadCallsRejectedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead queue population present", (Object)m.getBulkheadQueuePopulation().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"bulkhead wait time histogram present", (Object)m.getBulkheadWaitTime().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void bulkheadMetricRejectionTest() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(BulkheadMetricBean.class, "waitFor");
        m.baselineCounters();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        this.bulkheadBean.waitForRunningExecutions(2);
        Future<Void> f3 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Exceptions.expectBulkheadException(f3);
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)2L));
        waitingFuture.complete(null);
        f1.get();
        f2.get();
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCallsAcceptedDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"rejected calls", (Object)m.getBulkheadCallsRejectedDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void bulkheadMetricHistogramTest() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(BulkheadMetricBean.class, "waitForHistogram");
        m.baselineCounters();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        this.bulkheadBean.waitForRunningExecutions(2);
        Future<Void> f3 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        Exceptions.expectBulkheadException(f3);
        Thread.sleep(this.config.getTimeoutInMillis(1000L));
        waitingFuture.complete(null);
        f1.get();
        f2.get();
        Histogram executionTimes = m.getBulkheadExecutionDuration().get();
        Snapshot snap = executionTimes.getSnapshot();
        MatcherAssert.assertThat((String)"histogram count", (Object)executionTimes.getCount(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"median", (Object)Math.round(snap.getMedian()), MetricComparator.approxMillis(1000L));
        MatcherAssert.assertThat((String)"mean", (Object)Math.round(snap.getMean()), MetricComparator.approxMillis(1000L));
        this.bulkheadBean.waitForHistogram(CompletableFuture.completedFuture(null));
        this.bulkheadBean.waitForHistogram(CompletableFuture.completedFuture(null));
        snap = executionTimes.getSnapshot();
        MatcherAssert.assertThat((String)"histogram count", (Object)executionTimes.getCount(), (Matcher)Matchers.is((Object)4L));
        List values = Arrays.stream(snap.getValues()).sorted().boxed().collect(Collectors.toList());
        MatcherAssert.assertThat((String)"histogram values", values, (Matcher)Matchers.contains((Matcher[])new Matcher[]{MetricComparator.lessThanMillis(500L), MetricComparator.lessThanMillis(500L), MetricComparator.approxMillis(1000L), MetricComparator.approxMillis(1000L)}));
    }

    @Test
    public void bulkheadMetricAsyncTest() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(BulkheadMetricBean.class, "waitForAsync");
        m.baselineCounters();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.bulkheadBean.waitForAsync(waitingFuture);
        Future<Void> f2 = this.bulkheadBean.waitForAsync(waitingFuture);
        this.bulkheadBean.waitForRunningExecutions(2);
        long startTime = System.nanoTime();
        Future<Void> f3 = this.bulkheadBean.waitForAsync(waitingFuture);
        Future<Void> f4 = this.bulkheadBean.waitForAsync(waitingFuture);
        this.waitForQueuePopulation(m, 2, this.config.getTimeoutInMillis(2000L));
        Exceptions.expectBulkheadException(this.bulkheadBean.waitForAsync(waitingFuture));
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"queue population", (Object)m.getBulkheadQueuePopulation().get(), (Matcher)Matchers.is((Object)2L));
        Thread.sleep(this.config.getTimeoutInMillis(1000L));
        waitingFuture.complete(null);
        long durationms = (System.nanoTime() - startTime) / 1000000L;
        durationms = (long)((double)durationms / this.config.getBaseMultiplier());
        f1.get();
        f2.get();
        f3.get();
        f4.get();
        MatcherAssert.assertThat((String)"concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCallsAcceptedDelta(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"rejections", (Object)m.getBulkheadCallsRejectedDelta(), (Matcher)Matchers.is((Object)1L));
        Histogram queueWaits = m.getBulkheadWaitTime().get();
        Snapshot snap = queueWaits.getSnapshot();
        List values = Arrays.stream(snap.getValues()).sorted().boxed().collect(Collectors.toList());
        MatcherAssert.assertThat((String)"queue wait histogram counts", (Object)queueWaits.getCount(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"queue wait histogram values", values, (Matcher)Matchers.contains((Matcher[])new Matcher[]{MetricComparator.lessThanMillis(500L), MetricComparator.lessThanMillis(500L), MetricComparator.approxMillis(durationms), MetricComparator.approxMillis(durationms)}));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)5L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)1L));
    }

    private void waitForQueuePopulation(MetricGetter m, int expectedQueuePopulation, long timeoutInMs) throws InterruptedException {
        long timeoutTime = System.currentTimeMillis() + timeoutInMs;
        while (System.currentTimeMillis() < timeoutTime) {
            if (m.getBulkheadQueuePopulation().orElse(0L) == (long)expectedQueuePopulation) {
                return;
            }
            Thread.sleep(100L);
        }
    }
}

