/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.management.RuntimeErrorException;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BackendTestDelegate;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;

public class Checker
implements BackendTestDelegate {
    private int millis;
    private int fails = 0;
    private TestData td;
    private static final String BAR = "**************************************************************************************+++";

    public Checker(int sleepMillis, TestData td) {
        this.millis = sleepMillis;
        this.td = td;
        this.td.getInstances().incrementAndGet();
    }

    public Checker(int sleepMillis, TestData td, int fails) {
        this.fails = fails;
        this.millis = sleepMillis;
        this.td = td;
        this.td.getInstances().incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<String> perform() throws InterruptedException {
        try {
            int taskId = this.td.getTasksScheduled().incrementAndGet();
            int now = this.td.getWorkers().incrementAndGet();
            int max = this.td.getMaxSimultaneousWorkers().get();
            while (now > max && !this.td.getMaxSimultaneousWorkers().compareAndSet(max, now)) {
                max = this.td.getMaxSimultaneousWorkers().get();
            }
            if (this.fails > 0) {
                Thread.sleep(this.millis / 2);
                --this.fails;
                RuntimeErrorException e = new RuntimeErrorException(new Error("fake error for Retry Testing"));
                Utils.log(e.toString());
                throw e;
            }
            Utils.log("Task " + taskId + " sleeping for " + this.millis + " milliseconds. " + now + " workers inside Bulkhead from " + this.td.getInstances() + " instances " + BAR.substring(0, now));
            Thread.sleep(this.millis);
            Utils.log("Task " + taskId + " woke.");
        }
        catch (RuntimeException e) {
            Utils.log(e.toString());
        }
        finally {
            this.td.getWorkers().decrementAndGet();
            CountDownLatch latch = this.td.getLatch();
            if (latch != null) {
                latch.countDown();
            }
        }
        CompletableFuture<String> result = new CompletableFuture<String>();
        result.complete("max workers was " + this.td.getMaxSimultaneousWorkers().get());
        return result;
    }

    public int getSleep() {
        return this.millis;
    }
}

