/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.testng.Assert;

public class BulkheadTaskManager {
    private AsyncCaller executor;
    private List<BulkheadTask> startedTasks = new ArrayList<BulkheadTask>();

    private synchronized AsyncCaller getExecutor() {
        if (this.executor == null) {
            BeanManager bm = CDI.current().getBeanManager();
            Bean asyncCallerBean = bm.resolve(bm.getBeans(AsyncCaller.class, new Annotation[0]));
            this.executor = (AsyncCaller)bm.getReference(asyncCallerBean, AsyncCaller.class, bm.createCreationalContext(null));
        }
        return this.executor;
    }

    public BulkheadTask startTask(BulkheadTestBackend backend) {
        BulkheadTask task = new BulkheadTask(this.getExecutor(), backend);
        task.run();
        this.startedTasks.add(task);
        return task;
    }

    public void cleanup() throws InterruptedException {
        for (BulkheadTask task : this.startedTasks) {
            task.complete();
        }
        for (BulkheadTask task : this.startedTasks) {
            try {
                task.awaitFinished(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Unable to clean up all tasks");
            }
        }
        this.startedTasks = new ArrayList<BulkheadTask>();
    }
}

