/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10ClassSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5ClassSynchronousRetry12Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5MethodSynchronousRetry20Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5RapidRetry0MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5RapidRetry12MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryAbortOnSyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryDelaySyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.ParrallelBulkheadTest;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadSynchRetryTest
extends Arquillian {
    private BulkheadTaskManager manager = new BulkheadTaskManager();
    @Inject
    private AsyncCaller asyncCaller;
    @Inject
    private Bulkhead5MethodSynchronousRetry20Bean methodBean;
    @Inject
    private Bulkhead5ClassSynchronousRetry12Bean classBean;
    @Inject
    private Bulkhead55RapidRetry10MethodSynchBean rrMethodBean;
    @Inject
    private Bulkhead55RapidRetry10ClassSynchBean rrClassBean;
    @Inject
    private Bulkhead5RapidRetry0MethodSynchBean zeroRetryBean;
    @Inject
    private Bulkhead5RapidRetry12MethodSynchBean zeroRetryWaitingQueueBean;
    @Inject
    private BulkheadRetryDelaySyncBean retryDelaySyncBean;
    @Inject
    private BulkheadRetryAbortOnSyncBean retryAbortOnSyncBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadSynchRetryTest.jar")).addPackage(Bulkhead5ClassSynchronousRetry12Bean.class.getPackage())).addClass(Utils.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadSynchRetryTest.war")).addAsLibrary((Archive)testJar);
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @AfterMethod
    public void afterMethod() throws InterruptedException {
        this.manager.cleanup();
    }

    @AfterClass
    public void afterClass() throws InterruptedException {
        this.manager.cleanup();
    }

    @Test
    public void testBulkheadClassSynchronousPassiveRetry55() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(threads));
        this.threads(threads, this.classBean, maxSimultaneousWorkers, threads, td);
        td.check();
    }

    @Test
    public void testBulkheadRetriedMethodDueToFailures() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setLatch(null);
        Future[] results = new Future[threads];
        td.setMaxFill(false);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.asyncCaller.submit(new ParrallelBulkheadTest((BulkheadTestBackend)this.rrMethodBean, failOnce));
        }
        Utils.handleResults(threads, results);
        td.check();
    }

    @Test
    public void testBulkheadRetriedClassDueToFailures() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setLatch(null);
        Future[] results = new Future[threads];
        td.setMaxFill(false);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.asyncCaller.submit(new ParrallelBulkheadTest((BulkheadTestBackend)this.rrClassBean, failOnce));
        }
        Utils.handleResults(threads, results);
        td.check();
    }

    @Test
    public void testBulkheadMethodSynchronousRetry55() {
        int threads = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(20));
        this.threads(threads, this.methodBean, maxSimultaneousWorkers, threads, td);
        td.check();
    }

    @Test
    public void testBulkheadPassiveRetryMethodSynchronous55() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(threads));
        this.threads(threads, this.methodBean, maxSimultaneousWorkers, threads, td);
        td.check();
    }

    @Test
    public void testBulkheadRetryClassSynchronous55() {
        int threads = 20;
        int expectedTasks = 15;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.classBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testNoRetriesBulkhead() {
        int threads = 30;
        int maxSimultaneousWorkers = 5;
        int expectedTasks = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.zeroRetryBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testIgnoreWaitingTaskQueueBulkhead() {
        int threads = 30;
        int maxSimultaneousWorkers = 5;
        int expectedTasks = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.zeroRetryWaitingQueueBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testRetriesReenterBulkhead() throws InterruptedException {
        BulkheadTask taskA = this.manager.startTask(this.retryDelaySyncBean);
        taskA.assertStarting();
        taskA.completeExceptionally(new TestException());
        Thread.sleep(100L);
        BulkheadTask taskB = this.manager.startTask(this.retryDelaySyncBean);
        taskB.assertStarting();
        Exceptions.expectBulkheadException(taskA.getResultFuture());
        taskB.complete();
        taskB.assertFinishing();
    }

    @Test
    public void testNoRetriesWithoutRetryOn() throws InterruptedException {
        BulkheadTask taskA = this.manager.startTask(this.retryDelaySyncBean);
        taskA.assertStarting();
        long startTime = System.nanoTime();
        BulkheadTask taskB = this.manager.startTask(this.retryDelaySyncBean);
        Exceptions.expectBulkheadException(taskB.getResultFuture());
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(250L)));
    }

    @Test
    public void testNoRetriesWithAbortOn() throws InterruptedException {
        BulkheadTask taskA = this.manager.startTask(this.retryAbortOnSyncBean);
        taskA.assertStarting();
        long startTime = System.nanoTime();
        BulkheadTask taskB = this.manager.startTask(this.retryAbortOnSyncBean);
        Exceptions.expectBulkheadException(taskB.getResultFuture());
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(250L)));
    }

    private void threads(int number, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasks, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(number);
        td.setExpectedTasksScheduled(expectedTasks);
        Future[] results = new Future[number];
        for (int i = 0; i < number; ++i) {
            Utils.log("Starting test " + i);
            results[i] = this.asyncCaller.submit(new ParrallelBulkheadTest(test, td));
        }
        Utils.handleResults(number, results);
    }
}

