/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AsyncBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55ClassAsynchronousRetryBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55MethodAsynchronousRetryBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10ClassAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10MethodAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryAbortOnAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryDelayAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryQueueAsyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadAsynchRetryTest
extends Arquillian {
    private static final int DONT_CHECK = 0;
    @Inject
    private Bulkhead55MethodAsynchronousRetryBean methodBean;
    @Inject
    private Bulkhead55ClassAsynchronousRetryBean classBean;
    @Inject
    private Bulkhead55RapidRetry10ClassAsynchBean rrClassBean;
    @Inject
    private Bulkhead55RapidRetry10MethodAsynchBean rrMethodBean;
    @Inject
    private BulkheadRetryDelayAsyncBean retryDelayAsyncBean;
    @Inject
    private BulkheadRetryQueueAsyncBean retryQueueAsyncBean;
    @Inject
    private BulkheadRetryAbortOnAsyncBean retryAbortOnAsyncBean;
    private List<AsyncBulkheadTask> tasks = new ArrayList<AsyncBulkheadTask>();

    private AsyncBulkheadTask newTask() {
        AsyncBulkheadTask task = new AsyncBulkheadTask();
        this.tasks.add(task);
        return task;
    }

    @AfterMethod
    public void cleanupTasks() {
        for (AsyncBulkheadTask task : this.tasks) {
            task.complete();
        }
    }

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchRetryTest.jar")).addPackage(Bulkhead55ClassAsynchronousRetryBean.class.getPackage())).addClass(Utils.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchRetryTest.war")).addAsLibrary((Archive)testJar);
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassAsynchronousPassiveRetry55() {
        int iterations = 10;
        TestData td = new TestData(new CountDownLatch(iterations));
        Future[] results = Utils.loop(iterations, this.classBean, 5, iterations, td);
        Utils.handleResults(iterations, results);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousRetry55() {
        int iterations = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(iterations));
        Future[] results = Utils.loop(iterations, this.methodBean, maxSimultaneousWorkers, iterations, td);
        Utils.handleResults(iterations, results);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousRetry55Trip() throws InterruptedException {
        ArrayList<AsyncBulkheadTask> tasks = new ArrayList<AsyncBulkheadTask>();
        ArrayList<Future> results = new ArrayList<Future>();
        for (int i = 0; i < 5; ++i) {
            AsyncBulkheadTask task = this.newTask();
            tasks.add(task);
            Future result = this.rrClassBean.test(task);
            results.add(result);
            task.assertStarting(result);
        }
        ArrayList<AsyncBulkheadTask> nonStartingTasks = new ArrayList<AsyncBulkheadTask>();
        for (int i = 0; i < 5; ++i) {
            AsyncBulkheadTask task = this.newTask();
            tasks.add(task);
            nonStartingTasks.add(task);
            results.add(this.rrClassBean.test(task));
        }
        AsyncBulkheadTask.assertAllNotStarting(nonStartingTasks);
        AsyncBulkheadTask testTask = this.newTask();
        Future testResult = this.rrClassBean.test(testTask);
        testTask.assertNotStarting();
        Exceptions.expect(BulkheadException.class, testResult);
        for (AsyncBulkheadTask task : tasks) {
            task.complete();
        }
    }

    @Test
    public void testBulkheadMethodAsynchronous55RetryOverload() throws InterruptedException {
        int iterations = 1000;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        Future[] results = Utils.loop(iterations, this.rrMethodBean, maxSimultaneousWorkers, 0, td);
        int failures = 0;
        for (Future result : results) {
            try {
                result.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof BulkheadException) {
                    ++failures;
                    continue;
                }
                Assert.fail((String)"Unexpected non-bulkhead exception thrown", (Throwable)e);
            }
        }
        MatcherAssert.assertThat((String)"Failure count should be non-zero", (Object)failures, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testBulkheadClassAsynchronous55RetryOverload() throws InterruptedException {
        int iterations = 1000;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        Future[] results = Utils.loop(iterations, this.rrClassBean, maxSimultaneousWorkers, iterations, td);
        int failures = 0;
        for (Future result : results) {
            try {
                result.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof BulkheadException) {
                    ++failures;
                    continue;
                }
                Assert.fail((String)"Unexpected non-bulkhead exception thrown", (Throwable)e);
            }
        }
        MatcherAssert.assertThat((String)"Failure count should be non-zero", (Object)failures, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testBulkheadPassiveRetryMethodAsynchronous55() {
        int iterations = 10;
        TestData td = new TestData(new CountDownLatch(iterations));
        Future[] results = Utils.loop(iterations, this.methodBean, 5, iterations, td);
        Utils.handleResults(iterations, results);
        td.check();
    }

    @Test
    public void testBulkheadRetryClassAsynchronous55() {
        int iterations = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(iterations));
        Future[] results = Utils.loop(iterations, this.classBean, maxSimultaneousWorkers, iterations, td);
        Utils.handleResults(iterations, results);
        td.check();
    }

    @Test
    public void testBulkheadQueReplacesDueToClassRetryFailures() throws InterruptedException {
        int threads = 10;
        int maxSimultaneousWorkers = 5;
        Future[] results = new Future[threads];
        TestData td = new TestData(new CountDownLatch(threads));
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setMaxFill(false);
        td.setExpectedTasksScheduled(0);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.rrClassBean.test(failOnce);
        }
        Utils.handleResults(threads, results);
        td.check();
    }

    @Test
    public void testRetriesReenterBulkhead() throws InterruptedException, ExecutionException, TimeoutException {
        AsyncBulkheadTask taskA = this.newTask();
        Future resultA = this.retryDelayAsyncBean.test(taskA);
        taskA.assertStarting(resultA);
        AsyncBulkheadTask taskB = this.newTask();
        Future resultB = this.retryDelayAsyncBean.test(taskB);
        taskA.completeExceptionally(new TestException());
        taskB.assertStarting(resultB);
        AsyncBulkheadTask taskC = this.newTask();
        Future resultC = this.retryDelayAsyncBean.test(taskC);
        taskC.assertNotStarting();
        Exceptions.expectBulkheadException(resultA);
        taskB.complete(CompletableFuture.completedFuture("OK"));
        Assert.assertEquals(resultB.get(1L, TimeUnit.MINUTES), (Object)"OK", (String)"taskB should be complete");
        taskC.complete(CompletableFuture.completedFuture("OK"));
        Assert.assertEquals(resultC.get(1L, TimeUnit.MINUTES), (Object)"OK", (String)"taskC should be complete");
    }

    @Test
    public void testRetriesJoinBackOfQueue() throws InterruptedException, ExecutionException, TimeoutException {
        AsyncBulkheadTask taskA = this.newTask();
        Future resultA = this.retryQueueAsyncBean.test(taskA);
        taskA.assertStarting(resultA);
        AsyncBulkheadTask taskB = this.newTask();
        Future resultB = this.retryQueueAsyncBean.test(taskB);
        taskB.assertNotStarting();
        AsyncBulkheadTask taskC = this.newTask();
        Future resultC = this.retryQueueAsyncBean.test(taskC);
        taskC.assertNotStarting();
        taskA.completeExceptionally(new TestException());
        taskB.assertStarting(resultB);
        taskC.assertNotStarting();
        Assert.assertFalse((boolean)resultA.isDone(), (String)"Result A should not be complete yet");
        taskB.complete(CompletableFuture.completedFuture("OK"));
        Assert.assertEquals(resultB.get(2L, TimeUnit.SECONDS), (Object)"OK", (String)"ResultB should be complete");
        taskC.assertStarting(resultC);
        Assert.assertFalse((boolean)resultA.isDone(), (String)"Result A should still not be complete");
        taskC.complete(CompletableFuture.completedFuture("OK"));
        Assert.assertEquals(resultC.get(2L, TimeUnit.SECONDS), (Object)"OK", (String)"ResultC should be complete");
        Exceptions.expect(TestException.class, resultA);
    }

    @Test
    public void testNoRetriesWithoutRetryOn() throws InterruptedException {
        AsyncBulkheadTask taskA = this.newTask();
        this.retryDelayAsyncBean.test(taskA);
        taskA.assertStarting();
        AsyncBulkheadTask taskB = this.newTask();
        this.retryDelayAsyncBean.test(taskB);
        taskB.assertNotStarting();
        long startTime = System.nanoTime();
        AsyncBulkheadTask taskC = this.newTask();
        Future resultC = this.retryDelayAsyncBean.test(taskC);
        Exceptions.expectBulkheadException(resultC);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(250L)));
    }

    @Test
    public void testNoRetriesWithAbortOn() throws InterruptedException {
        AsyncBulkheadTask taskA = this.newTask();
        this.retryAbortOnAsyncBean.test(taskA);
        taskA.assertStarting();
        AsyncBulkheadTask taskB = this.newTask();
        this.retryAbortOnAsyncBean.test(taskB);
        taskB.assertNotStarting();
        long startTime = System.nanoTime();
        AsyncBulkheadTask taskC = this.newTask();
        Future resultC = this.retryAbortOnAsyncBean.test(taskC);
        Exceptions.expectBulkheadException(resultC);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(250L)));
    }
}

