/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.asynchronous;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AsyncBulkheadTask;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class AsyncCancellationClient {
    private AtomicInteger serviceAsyncRetryAttempts = new AtomicInteger(0);

    @Asynchronous
    public Future serviceAsync(AsyncBulkheadTask task) throws InterruptedException {
        return task.perform();
    }

    @Asynchronous
    @Retry(maxRetries=5)
    public Future serviceAsyncRetry(AsyncBulkheadTask task) throws InterruptedException {
        this.serviceAsyncRetryAttempts.incrementAndGet();
        return task.perform();
    }

    public int getServiceAsyncRetryAttempts() {
        return this.serviceAsyncRetryAttempts.get();
    }

    @Asynchronous
    @Bulkhead(value=1, waitingTaskQueue=1)
    public Future serviceAsyncBulkhead(AsyncBulkheadTask task) throws InterruptedException {
        return task.perform();
    }
}

