/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.exception.hierarchy.CircuitBreakerService;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2S;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerExceptionHierarchyTest
extends Arquillian {
    @Inject
    private CircuitBreakerService service;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerExceptionHierarchy.jar")).addPackage(E0.class.getPackage())).addClass(CircuitBreakerService.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerExceptionHierarchy.war")).addAsLibrary((Archive)jar);
    }

    @Test
    public void serviceAthrowsException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA1, new Exception())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA2, new E0())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceAthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA3, new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA4, new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA5, new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA6, new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA7, new E0S())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceAthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA8, new RuntimeException())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsError() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceA9, new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB1, new Exception())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceBthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB2, new E0())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB3, new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB4, new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB5, new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB6, new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB7, new E0S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB8, new RuntimeException())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceBthrowsError() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceB9, new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC1, new Exception())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC2, new E0())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC3, new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC4, new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC5, new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC6, new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC7, new E0S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC8, new RuntimeException())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsError() {
        Assert.assertEquals((Object)((Object)this.invoke(this.service::serviceC9, new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    private CircuitState invoke(ServiceMethod method, Throwable exception) {
        try {
            method.invoke(exception);
            throw new AssertionError((Object)"Exception not thrown from service method");
        }
        catch (Throwable ex) {
            Assert.assertEquals((Object)ex, (Object)exception);
            try {
                method.invoke(exception);
                throw new AssertionError((Object)"Exception not thrown from service method");
            }
            catch (CircuitBreakerOpenException ex2) {
                return CircuitState.OPEN;
            }
            catch (Throwable ex3) {
                Assert.assertEquals((Object)ex3, (Object)exception);
                return CircuitState.CLOSED;
            }
        }
    }

    private static enum CircuitState {
        CLOSED,
        OPEN;

    }

    @FunctionalInterface
    private static interface ServiceMethod {
        public void invoke(Throwable var1) throws Throwable;
    }
}

