/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AbstractBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.testng.Assert;

public class BulkheadTask
extends AbstractBulkheadTask {
    private BulkheadTestBackend testBackend;
    private AsyncCaller executor;
    private CompletableFuture<Future> resultFuture = new CompletableFuture();

    public BulkheadTask(AsyncCaller executor, BulkheadTestBackend testBackend) {
        this.executor = executor;
        this.testBackend = testBackend;
    }

    public void awaitFinished(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.resultFuture.get(timeout, unit);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public Future getResult() throws ExecutionException {
        try {
            return this.resultFuture.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"getResult() called when task not finished", (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Unexpected InterruptedException when getting the result", (Throwable)e);
            return null;
        }
    }

    public Future getResultFuture() {
        return this.resultFuture;
    }

    public void run() {
        this.executor.run(() -> {
            try {
                this.resultFuture.complete(this.testBackend.test(new AbstractBulkheadTask.TestDelegate(this)));
            }
            catch (Exception e) {
                this.resultFuture.completeExceptionally(e);
            }
        });
    }

    @Override
    public void assertStarting() throws InterruptedException {
        super.assertStarting(this.resultFuture);
    }

    public void assertFinishing() throws InterruptedException {
        try {
            this.awaitFinished(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Task did not finish within 2 seconds");
        }
    }

    public void assertNotFinishing() throws InterruptedException {
        try {
            this.awaitFinished(2L, TimeUnit.SECONDS);
            Assert.fail((String)"Task finished unexpectedly");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void assertSuccessful() throws InterruptedException {
        try {
            this.getResult();
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Task did not complete successfully", (Throwable)e);
        }
    }

    public void assertThrows(Class<? extends Throwable> exceptionClazz) throws InterruptedException {
        block2: {
            try {
                this.getResult();
                Assert.fail((String)("Task did not throw " + exceptionClazz.getName()));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (exceptionClazz.isInstance(cause)) break block2;
                Assert.fail((String)("Unexpected exception thrown from task: " + cause), (Throwable)cause);
            }
        }
    }
}

