/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BackendTestDelegate;
import org.testng.Assert;

public class AbstractBulkheadTask {
    protected CompletableFuture<Void> runningLatch = new CompletableFuture();
    protected CompletableFuture<Future> releaseLatch = new CompletableFuture();
    protected CompletableFuture<Boolean> interruptedLatch = new CompletableFuture();

    public void awaitRunning(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.runningLatch.get(timeout, unit);
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Unexpected execution exception during awaitRunning", (Throwable)e);
        }
    }

    public void complete() {
        this.releaseLatch.complete(CompletableFuture.completedFuture("OK"));
    }

    public void complete(Future result) {
        this.releaseLatch.complete(result);
    }

    public void completeExceptionally(RuntimeException e) {
        this.releaseLatch.completeExceptionally(e);
    }

    public void assertStarting() throws InterruptedException {
        this.doAssertStarting();
    }

    public void assertNotStarting() throws InterruptedException {
        try {
            this.awaitRunning(2L, TimeUnit.SECONDS);
            Assert.fail((String)"Task started unexpectedly");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void assertAllNotStarting(Collection<? extends AbstractBulkheadTask> tasks) throws InterruptedException {
        Thread.sleep(2000L);
        int i = 0;
        for (AbstractBulkheadTask abstractBulkheadTask : tasks) {
            Assert.assertFalse((boolean)abstractBulkheadTask.runningLatch.isDone(), (String)("Task " + i + " is running."));
            ++i;
        }
    }

    private final void doAssertStarting() throws InterruptedException {
        try {
            this.awaitRunning(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Task did not start within 2 seconds");
        }
    }

    public void assertStarting(Future methodResult) throws InterruptedException {
        try {
            this.doAssertStarting();
        }
        catch (AssertionError err) {
            if (methodResult.isDone()) {
                try {
                    Object result = methodResult.get(0L, TimeUnit.SECONDS);
                    Assert.fail((String)("Task did not start within 2 seconds. Method result: complete with result: " + result));
                }
                catch (CancellationException e) {
                    Assert.fail((String)"Task did not start within 2 seconds. Method result: cancelled", (Throwable)e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    Assert.fail((String)("Task did not start within 2 seconds. Method result: failed with exception: " + cause), (Throwable)cause);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Task did not start within 2 seconds. Additionally, an InterruptedException was received when trying to check the method result", (Throwable)e);
                }
                catch (TimeoutException e) {
                    Assert.fail((String)"Task did not start within 2 seconds. Additionally, although the method result future reported done, a TimeoutException was received when trying to check the method result", (Throwable)e);
                }
            }
            Assert.fail((String)"Task did not start within 2 seconds. Method result: incomplete");
        }
    }

    public void assertInterrupting() throws InterruptedException {
        try {
            boolean interrupted = this.awaitInterruptedResult(2L, TimeUnit.SECONDS);
            if (!interrupted) {
                Assert.fail((String)"Task completed without being interrupted");
            }
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Task had not been interrupted after two seconds", (Throwable)e);
        }
    }

    public void assertNotInterrupting() throws InterruptedException {
        try {
            boolean interrupted = this.awaitInterruptedResult(2L, TimeUnit.SECONDS);
            if (interrupted) {
                Assert.fail((String)"Task was interrupted within two seconds");
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public boolean awaitInterruptedResult(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            return this.interruptedLatch.get(time, unit);
        }
        catch (ExecutionException e) {
            throw new AssertionError("Unexpected execution exception during awaitInterruptedResult", e);
        }
    }

    protected class TestDelegate
    implements BackendTestDelegate {
        protected TestDelegate() {
        }

        @Override
        public Future perform() throws InterruptedException {
            AbstractBulkheadTask.this.runningLatch.complete(null);
            try {
                Future future = AbstractBulkheadTask.this.releaseLatch.get(1L, TimeUnit.MINUTES);
                return future;
            }
            catch (ExecutionException e) {
                throw (RuntimeException)e.getCause();
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Timeout waiting for release() to be called", (Throwable)e);
                Future future = null;
                return future;
            }
            catch (InterruptedException e) {
                AbstractBulkheadTask.this.interruptedLatch.complete(true);
                throw e;
            }
            finally {
                AbstractBulkheadTask.this.interruptedLatch.complete(false);
            }
        }
    }
}

