/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AbstractBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AsyncBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10ClassAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10MethodAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3ClassAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3MethodAsynchronousBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadCompletionStageBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadAsynchTest
extends Arquillian {
    @Inject
    private BulkheadClassAsynchronousDefaultBean bhBeanClassAsynchronousDefault;
    @Inject
    private BulkheadMethodAsynchronousDefaultBean bhBeanMethodAsynchronousDefault;
    @Inject
    private Bulkhead3ClassAsynchronousBean bhBeanClassAsynchronous3;
    @Inject
    private Bulkhead3MethodAsynchronousBean bhBeanMethodAsynchronous3;
    @Inject
    private Bulkhead10ClassAsynchronousBean bhBeanClassAsynchronous10;
    @Inject
    private Bulkhead10MethodAsynchronousBean bhBeanMethodAsynchronous10;
    @Inject
    private BulkheadClassAsynchronousQueueingBean bhBeanClassAsynchronousQueueing;
    @Inject
    private BulkheadMethodAsynchronousQueueingBean bhBeanMethodAsynchronousQueueing;
    @Inject
    private BulkheadCompletionStageBean bhBeanCompletionStage;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchTest.jar")).addPackage(BulkheadClassAsynchronousDefaultBean.class.getPackage())).addClass(Utils.class)).addClass(CompletableFutureHelper.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchTest.war")).addAsLibrary((Archive)testJar);
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassAsynchronous10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronous10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronous10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronous10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronous3() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronous3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronous3() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronous3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronousDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronousDefault, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronousDefault, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronousQueueing10() {
        TestData td = new TestData(new CountDownLatch(20));
        this.loop(20, this.bhBeanClassAsynchronousQueueing, 10, 20, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousQueueing10() {
        TestData td = new TestData(new CountDownLatch(20));
        this.loop(20, this.bhBeanMethodAsynchronousQueueing, 10, 20, td);
        td.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkheadExceptionThrownWhenQueueFullAsync() throws InterruptedException {
        ArrayList<AsyncBulkheadTask> tasks = new ArrayList<AsyncBulkheadTask>();
        try {
            Future result;
            for (int i = 0; i < 10; ++i) {
                AsyncBulkheadTask task = new AsyncBulkheadTask();
                tasks.add(task);
                result = this.bhBeanClassAsynchronousDefault.test(task);
                task.assertStarting(result);
            }
            ArrayList<AsyncBulkheadTask> queuingTasks = new ArrayList<AsyncBulkheadTask>();
            for (int i = 0; i < 10; ++i) {
                AsyncBulkheadTask task = new AsyncBulkheadTask();
                tasks.add(task);
                queuingTasks.add(task);
                this.bhBeanClassAsynchronousDefault.test(task);
            }
            AbstractBulkheadTask.assertAllNotStarting(queuingTasks);
            AsyncBulkheadTask task = new AsyncBulkheadTask();
            tasks.add(task);
            result = this.bhBeanClassAsynchronousDefault.test(task);
            task.assertNotStarting();
            Assert.assertTrue((boolean)result.isDone(), (String)"When a task is rejected from the bulkhead, the returned future should report as done");
            Exceptions.expect(BulkheadException.class, result);
        }
        finally {
            for (AsyncBulkheadTask task : tasks) {
                task.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkheadCompletionStage() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            CompletableFuture<Void> future1 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            CompletableFuture<Void> future2 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(200L));
            CompletableFuture<Void> future3 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            CompletableFuture<Void> future4 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(200L));
            CompletableFuture<Void> future5 = CompletableFutureHelper.toCompletableFuture(this.bhBeanCompletionStage.serviceCS(result));
            Assert.assertFalse((boolean)future1.isDone(), (String)"Future1 reported done");
            Assert.assertFalse((boolean)future2.isDone(), (String)"Future2 reported done");
            Exceptions.expectBulkheadException(future5);
            result.complete(null);
            future1.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future2.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future3.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            future4.get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
        }
        finally {
            result.complete(null);
        }
    }

    private void loop(int loops, BulkheadTestBackend test, int maxSimultaneousWorkers, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(loops);
        td.setExpectedTasksScheduled(loops);
        Future[] results = new Future[loops];
        for (int i = 0; i < loops; ++i) {
            Utils.log("synchronous loop() starting test " + i);
            try {
                results[i] = test.test(new Checker(5000, td));
                continue;
            }
            catch (InterruptedException e1) {
                Assert.fail((String)"Unexpected interruption", (Throwable)e1);
            }
        }
        Utils.handleResults(loops, results);
    }

    private void loop(int number, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasksScheduled, TestData td) {
        td.setExpectedTasksScheduled(expectedTasksScheduled);
        this.loop(number, test, maxSimultaneousWorkers, td);
    }
}

