/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.exception.hierarchy.CircuitBreakerService;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2S;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CircuitBreakerExceptionHierarchyTest
extends Arquillian {
    @Inject
    private Instance<CircuitBreakerService> serviceInstance;
    private CircuitBreakerService service;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerExceptionHierarchy.jar")).addPackage(E0.class.getPackage())).addClass(CircuitBreakerService.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerExceptionHierarchy.war")).addAsLibrary((Archive)jar);
    }

    @BeforeMethod
    public void setup() {
        if (this.serviceInstance != null) {
            this.service = (CircuitBreakerService)this.serviceInstance.get();
        }
    }

    @AfterMethod
    public void teardown() {
        if (this.serviceInstance != null) {
            this.serviceInstance.destroy((Object)this.service);
        }
    }

    @Test
    public void serviceAthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Exception())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceAthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0S())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceAthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new RuntimeException())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceAthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    private CircuitState invokeServiceA(Throwable exception) {
        try {
            this.service.serviceA(exception);
            throw new AssertionError((Object)"Exception not thrown from serviceA");
        }
        catch (Throwable ex) {
            Assert.assertEquals((Object)ex, (Object)exception);
            try {
                this.service.serviceA(exception);
                throw new AssertionError((Object)"Exception not thrown from serviceA");
            }
            catch (CircuitBreakerOpenException ex2) {
                return CircuitState.OPEN;
            }
            catch (Throwable ex3) {
                Assert.assertEquals((Object)ex3, (Object)exception);
                return CircuitState.CLOSED;
            }
        }
    }

    @Test
    public void serviceBthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new Exception())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceBthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceBthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new RuntimeException())), (Object)((Object)CircuitState.OPEN));
    }

    @Test
    public void serviceBthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    private CircuitState invokeserviceB(Throwable exception) {
        try {
            this.service.serviceB(exception);
            throw new AssertionError((Object)"Exception not thrown from serviceB");
        }
        catch (Throwable ex) {
            Assert.assertEquals((Object)ex, (Object)exception);
            try {
                this.service.serviceB(exception);
                throw new AssertionError((Object)"Exception not thrown from serviceB");
            }
            catch (CircuitBreakerOpenException ex2) {
                return CircuitState.OPEN;
            }
            catch (Throwable ex3) {
                Assert.assertEquals((Object)ex3, (Object)exception);
                return CircuitState.CLOSED;
            }
        }
    }

    @Test
    public void serviceCthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Exception())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0S())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new RuntimeException())), (Object)((Object)CircuitState.CLOSED));
    }

    @Test
    public void serviceCthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Error())), (Object)((Object)CircuitState.CLOSED));
    }

    private CircuitState invokeServiceC(Throwable exception) {
        try {
            this.service.serviceC(exception);
            throw new AssertionError((Object)"Exception not thrown from serviceC");
        }
        catch (Throwable ex) {
            Assert.assertEquals((Object)ex, (Object)exception);
            try {
                this.service.serviceC(exception);
                throw new AssertionError((Object)"Exception not thrown from serviceC");
            }
            catch (CircuitBreakerOpenException ex2) {
                return CircuitState.OPEN;
            }
            catch (Throwable ex3) {
                Assert.assertEquals((Object)ex3, (Object)exception);
                return CircuitState.CLOSED;
            }
        }
    }

    private static enum CircuitState {
        CLOSED,
        OPEN;

    }
}

