/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncCancellationClient;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.AsyncBulkheadTask;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class AsyncCancellationTest
extends Arquillian {
    @Inject
    private AsyncCancellationClient bean;
    private static List<AsyncBulkheadTask> tasks = new ArrayList<AsyncBulkheadTask>();

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsyncCancellation.jar")).addClasses(new Class[]{AsyncCancellationClient.class})).addPackage(AsyncBulkheadTask.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsyncCancellation.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @AfterMethod
    public void cleanup() {
        for (AsyncBulkheadTask task : tasks) {
            task.complete();
        }
        tasks.clear();
    }

    private static AsyncBulkheadTask newTask() {
        AsyncBulkheadTask task = new AsyncBulkheadTask();
        tasks.add(task);
        return task;
    }

    @Test
    public void testCancel() throws InterruptedException {
        AsyncBulkheadTask task = AsyncCancellationTest.newTask();
        Future result = this.bean.serviceAsync(task);
        task.assertStarting(result);
        result.cancel(true);
        task.assertInterrupting();
        Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
        Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
        Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
        Exceptions.expect(CancellationException.class, () -> result.get());
        task.complete();
        Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
        Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
        Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
        Exceptions.expect(CancellationException.class, () -> result.get());
    }

    @Test
    public void testCancelWithoutInterrupt() throws InterruptedException {
        AsyncBulkheadTask task = AsyncCancellationTest.newTask();
        Future result = this.bean.serviceAsync(task);
        task.assertStarting(result);
        result.cancel(false);
        task.assertNotInterrupting();
        Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
        Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
        Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
        Exceptions.expect(CancellationException.class, () -> result.get());
        task.complete();
        Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
        Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
        Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
        Exceptions.expect(CancellationException.class, () -> result.get());
    }

    @Test
    public void testCancelledButRemainsInBulkhead() throws InterruptedException {
        AsyncBulkheadTask task1 = AsyncCancellationTest.newTask();
        Future result1 = this.bean.serviceAsyncBulkhead(task1);
        task1.assertStarting();
        AsyncBulkheadTask task2 = AsyncCancellationTest.newTask();
        Future result2 = this.bean.serviceAsyncBulkhead(task2);
        task2.assertNotStarting();
        result1.cancel(false);
        task2.assertNotStarting();
        Assert.assertTrue((boolean)result1.isCancelled(), (String)"Task is not cancelled");
        Assert.assertTrue((boolean)result1.isDone(), (String)"Task is not done");
        Exceptions.expect(CancellationException.class, () -> result1.get(2L, TimeUnit.SECONDS));
        Exceptions.expect(CancellationException.class, () -> result1.get());
    }

    @Test
    public void testCancelledWhileQueued() throws InterruptedException {
        AsyncBulkheadTask task1 = AsyncCancellationTest.newTask();
        Future result1 = this.bean.serviceAsyncBulkhead(task1);
        task1.assertStarting();
        AsyncBulkheadTask task2 = AsyncCancellationTest.newTask();
        Future result2 = this.bean.serviceAsyncBulkhead(task2);
        task2.assertNotStarting();
        result2.cancel(false);
        task1.complete();
        task2.assertNotStarting();
    }

    @Test
    public void testCancelledDoesNotRetry() throws InterruptedException {
        AsyncBulkheadTask task = AsyncCancellationTest.newTask();
        Future result = this.bean.serviceAsyncRetry(task);
        task.assertStarting();
        result.cancel(true);
        Thread.sleep(500L);
        Assert.assertEquals((int)this.bean.getServiceAsyncRetryAttempts(), (int)1, (String)"Method should not have been retried - too many retry attempts");
    }
}

