/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.AllMetricsBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class AllMetricsTest
extends Arquillian {
    @Inject
    private AllMetricsBean allMetricsBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricAll.war")).addClasses(new Class[]{AllMetricsBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testAllMetrics() throws InterruptedException, ExecutionException {
        MetricGetter m = new MetricGetter(AllMetricsBean.class, "doWork");
        m.baselineCounters();
        this.allMetricsBean.doWork().get();
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls succeeded without retry", (Object)m.getRetryCallsSucceededNotRetriedDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"calls succeeded after retry", (Object)m.getRetryCallsSucceededRetriedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls failed", (Object)m.getRetryCallsFailedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetriesDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"timeout execution duration histogram present", (Object)m.getTimeoutExecutionDuration().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"timed out calls", (Object)m.getTimeoutCallsTimedOutDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"non timed out calls", (Object)m.getTimeoutCallsNotTimedOutDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker succeeded calls", (Object)m.getCircuitBreakerCallsSucceededDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker failed calls", (Object)m.getCircuitBreakerCallsFailedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker prevented calls", (Object)m.getCircuitBreakerCallsPreventedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker closed time", (Object)m.getCircuitBreakerTimeClosedDelta(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((String)"circuitbreaker half open time", (Object)m.getCircuitBreakerTimeHalfOpenDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker open time", (Object)m.getCircuitBreakerTimeOpenDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker times opened", (Object)m.getCircuitBreakerOpenedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead concurrent executions", (Object)m.getBulkheadConcurrentExecutions().get(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead accepted calls", (Object)m.getBulkheadCallsAcceptedDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"bulkhead rejected calls", (Object)m.getBulkheadCallsRejectedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead duration histogram present", (Object)m.getBulkheadExecutionDuration().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"bulkhead queue population present", (Object)m.getBulkheadQueuePopulation().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"bulkhead queue wait time histogram present", (Object)m.getBulkheadWaitTime().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"fallback calls", (Object)m.getFallbackCallsDelta(), (Matcher)Matchers.is((Object)0L));
    }
}

