/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.timeout.clientserver.UninterruptableTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class TimeoutUninterruptableTest
extends Arquillian {
    private List<CompletableFuture<Void>> waitingFutures = new ArrayList<CompletableFuture<Void>>();
    @Inject
    private UninterruptableTimeoutClient client;

    @Deployment
    public static WebArchive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftTimeoutUninterruptable.jar")).addClass(UninterruptableTimeoutClient.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive testWar = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftTimeoutUninterruptable.war")).addAsLibrary((Archive)testJar);
        return testWar;
    }

    @Test
    public void testTimeout() {
        long startTime = System.nanoTime();
        Exceptions.expectTimeout(() -> this.client.serviceTimeout(1000));
        long endTime = System.nanoTime();
        Assert.assertFalse((boolean)Thread.interrupted(), (String)"Thread was still interrupted when method returned");
        MatcherAssert.assertThat((String)"Execution time (ns)", (Object)(endTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(Duration.ofMillis(1000L).toNanos())));
    }

    @Test
    public void testTimeoutAsync() throws Exception {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        long startTime = System.nanoTime();
        Future<Void> result = this.client.serviceTimeoutAsync(waitingFuture, completionFuture);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, result);
        long resultTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time for result to be complete", (Object)Duration.ofNanos(resultTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(1500L)));
        Assert.assertFalse((boolean)completionFuture.isDone(), (String)"Method should still be running");
        waitingFuture.complete(null);
        completionFuture.get(2L, TimeUnit.SECONDS);
    }

    @Test
    public void testTimeoutAsyncCS() throws InterruptedException {
        AtomicBoolean wasInterrupted = new AtomicBoolean(false);
        CompletableFuture completionFuture = new CompletableFuture();
        AtomicLong endTime = new AtomicLong();
        long startTime = System.nanoTime();
        this.client.serviceTimeoutAsyncCS(4000L).thenRun(() -> completionFuture.complete(null)).exceptionally(e -> {
            completionFuture.completeExceptionally((Throwable)e);
            return null;
        }).thenRun(() -> endTime.set(System.nanoTime())).thenRun(() -> wasInterrupted.set(Thread.interrupted()));
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, completionFuture);
        Assert.assertFalse((boolean)wasInterrupted.get(), (String)"Thread was still interrupted when thenRun steps were run");
        MatcherAssert.assertThat((String)"Execution time", (Object)Duration.ofNanos(endTime.get() - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(1500L)));
    }

    @Test
    public void testTimeoutAsyncBulkhead() throws InterruptedException {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        long startTime = System.nanoTime();
        Future<Void> resultA = this.client.serviceTimeoutAsyncBulkhead(waitingFuture);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, resultA);
        long resultTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time for result to be complete", (Object)Duration.ofNanos(resultTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(1500L)));
        Assert.assertEquals((int)this.client.getTimeoutAsyncBulkheadCounter(), (int)1, (String)"Execution count after first call");
        startTime = System.nanoTime();
        Future<Void> resultB = this.client.serviceTimeoutAsyncBulkhead(waitingFuture);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, resultB);
        resultTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time for result to be complete", (Object)Duration.ofNanos(resultTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(1500L)));
        Assert.assertEquals((int)this.client.getTimeoutAsyncBulkheadCounter(), (int)1, (String)"Execution count after second call");
        Future<Void> resultC = this.client.serviceTimeoutAsyncBulkhead(waitingFuture);
        Thread.sleep(100L);
        Future<Void> resultD = this.client.serviceTimeoutAsyncBulkhead(waitingFuture);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, resultC);
        Exceptions.expect(BulkheadException.class, resultD);
        Assert.assertEquals((int)this.client.getTimeoutAsyncBulkheadCounter(), (int)1, (String)"Execution count after fourth call");
        waitingFuture.complete(null);
        Thread.sleep(300L);
        Assert.assertEquals((int)this.client.getTimeoutAsyncBulkheadCounter(), (int)1, (String)"Execution count after completing all tasks");
    }

    @Test
    public void testTimeoutAsyncBulkheadQueueTimed() throws InterruptedException {
        CompletableFuture<Void> waitingFutureA = this.newWaitingFuture();
        CompletableFuture<Void> waitingFutureB = this.newWaitingFuture();
        this.client.serviceTimeoutAsyncBulkheadQueueTimed(waitingFutureA);
        Thread.sleep(100L);
        long startTime = System.nanoTime();
        Future<Void> resultB = this.client.serviceTimeoutAsyncBulkheadQueueTimed(waitingFutureB);
        Thread.sleep(300L);
        waitingFutureA.complete(null);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, resultB);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time taken for call B to timeout", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(750L)));
    }

    @Test
    public void testTimeoutAsyncRetry() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        long startTime = System.nanoTime();
        Future<Void> result = this.client.serviceTimeoutAsyncRetry(waitingFuture);
        Exceptions.expect(org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, result);
        long resultTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time for result to complete", (Object)Duration.ofNanos(resultTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(3000L)));
        Assert.assertEquals((int)this.client.getTimeoutAsyncRetryCounter(), (int)3, (String)"Execution count after one call");
    }

    @Test
    public void testTimeoutAsyncFallback() throws InterruptedException {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        long startTime = System.nanoTime();
        Future<String> resultFuture = this.client.serviceTimeoutAsyncFallback(waitingFuture);
        try {
            Assert.assertEquals((String)resultFuture.get(1L, TimeUnit.MINUTES), (String)"FALLBACK");
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Method did not complete", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Unexpected exception thrown", (Throwable)e);
        }
        long resultTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Time for result to be complete", (Object)Duration.ofNanos(resultTime - startTime), (Matcher)Matchers.lessThan((Comparable)Duration.ofMillis(1500L)));
    }

    private CompletableFuture<Void> newWaitingFuture() {
        CompletableFuture<Void> waitingFuture = new CompletableFuture<Void>();
        this.waitingFutures.add(waitingFuture);
        return waitingFuture;
    }

    @AfterMethod
    public void cleanup() {
        for (CompletableFuture<Void> future : this.waitingFutures) {
            future.complete(null);
        }
        this.waitingFutures.clear();
    }
}

