/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import java.sql.Connection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class RetryClientWithNoDelayAndJitter {
    private int counterForInvokingConnectionService = 0;
    private long timestampForConnectionService = 0L;
    private final List<Long> delayTimes = new ArrayList<Long>();

    @Retry(delay=0L, maxDuration=3200L, jitter=400L, maxRetries=100)
    public Connection serviceA() {
        return this.connectionService();
    }

    private Connection connectionService() {
        long currentTime = System.nanoTime();
        if (this.timestampForConnectionService != 0L) {
            Duration delayDuration = Duration.ofNanos(currentTime - this.timestampForConnectionService);
            this.delayTimes.add(delayDuration.toMillis());
        }
        this.timestampForConnectionService = currentTime;
        ++this.counterForInvokingConnectionService;
        throw new RuntimeException("Connection failed");
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnectionService;
    }

    public int positiveDelays() {
        System.out.println("delays are: " + this.delayTimes);
        int count = 0;
        for (long delayTime : this.delayTimes) {
            if (delayTime <= 5L) continue;
            ++count;
        }
        return count;
    }
}

