/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BackendTestDelegate;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.testng.Assert;

public class ParrallelBulkheadTest
implements Callable<Future> {
    protected BulkheadTestBackend target;
    protected BackendTestDelegate action;

    public ParrallelBulkheadTest(BulkheadTestBackend target, BackendTestDelegate action) {
        this.target = target;
        this.action = action;
    }

    public ParrallelBulkheadTest(BulkheadTestBackend target, TestData td) {
        this.target = target;
        this.action = new Checker(1000, td);
    }

    @Override
    public Future call() throws Exception {
        Utils.log("action " + this.action);
        Utils.log("target " + this.target);
        Future result = null;
        try {
            result = this.target.test(this.action);
        }
        catch (BulkheadException b) {
            Utils.log("Might expect a Bulkhead exception from some tests : " + b.toString() + b.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected exception: " + t.toString()), (Throwable)t);
        }
        return result;
    }
}

