/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.testng.Assert;

public class TestData {
    private AtomicInteger workers = new AtomicInteger(0);
    private AtomicInteger maxSimultaneousWorkers = new AtomicInteger(0);
    private AtomicInteger instances = new AtomicInteger(0);
    private AtomicInteger tasksScheduled = new AtomicInteger(0);
    private int expectedInstances;
    private int expectedMaxSimultaneousWorkers;
    private int expectedTasksScheduled;
    private boolean maxFill = true;
    private CountDownLatch latch = null;

    public TestData(CountDownLatch countDownLatch) {
        this.latch = countDownLatch;
    }

    public TestData() {
    }

    public AtomicInteger getWorkers() {
        return this.workers;
    }

    public void setWorkers(AtomicInteger workers) {
        this.workers = workers;
    }

    public AtomicInteger getMaxSimultaneousWorkers() {
        return this.maxSimultaneousWorkers;
    }

    public void setMaxSimultaneousWorkers(AtomicInteger maxSimultaneousWorkers) {
        this.maxSimultaneousWorkers = maxSimultaneousWorkers;
    }

    public AtomicInteger getInstances() {
        return this.instances;
    }

    public void setInstances(AtomicInteger instances) {
        this.instances = instances;
    }

    public AtomicInteger getTasksScheduled() {
        return this.tasksScheduled;
    }

    public void setTasksScheduled(AtomicInteger tasksScheduled) {
        this.tasksScheduled = tasksScheduled;
    }

    public int getExpectedInstances() {
        return this.expectedInstances;
    }

    public void setExpectedInstances(int expectedInstances) {
        this.expectedInstances = expectedInstances;
    }

    public int getExpectedMaxSimultaneousWorkers() {
        return this.expectedMaxSimultaneousWorkers;
    }

    public void setExpectedMaxSimultaneousWorkers(int expectedMaxSimultaneousWorkers) {
        this.expectedMaxSimultaneousWorkers = expectedMaxSimultaneousWorkers;
    }

    public int getExpectedTasksScheduled() {
        return this.expectedTasksScheduled;
    }

    public boolean isMaxFill() {
        return this.maxFill;
    }

    public void setMaxFill(boolean maxFill) {
        this.maxFill = maxFill;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setExpectedTasksScheduled(int expected) {
        if (this.tasksScheduled.get() != 0 && this.expectedTasksScheduled != this.tasksScheduled.get()) {
            Utils.log("WARNING: expectedTasksScheduled being set to " + expected + " while tasksScheduled was " + this.tasksScheduled.get() + " this will make this check likely to FAIL.");
        }
        this.expectedTasksScheduled = expected;
    }

    public void check() {
        if (this.latch != null) {
            try {
                this.latch.await(50000L, TimeUnit.MILLISECONDS);
                Assert.assertEquals((int)this.getWorkers().get(), (int)0, (String)"Some workers still active. ");
            }
            catch (InterruptedException e) {
                Utils.log(e.getLocalizedMessage());
            }
        }
        Assert.assertFalse((this.getExpectedInstances() != 0 && this.getInstances().get() < this.getExpectedInstances() ? 1 : 0) != 0, (String)(" Not all workers launched. " + this.getInstances().get() + "/" + this.getExpectedInstances()));
        Assert.assertTrue((this.getMaxSimultaneousWorkers().get() <= this.getExpectedMaxSimultaneousWorkers() ? 1 : 0) != 0, (String)(" Bulkhead appears to have been breeched " + this.getMaxSimultaneousWorkers() + " workers, expected " + this.getExpectedMaxSimultaneousWorkers() + ". "));
        Assert.assertFalse((this.isMaxFill() && this.getExpectedMaxSimultaneousWorkers() > 1 && this.getMaxSimultaneousWorkers().get() == 1 ? 1 : 0) != 0, (String)" Workers are not in parrallel. ");
        Assert.assertTrue((!this.isMaxFill() || this.getExpectedMaxSimultaneousWorkers() == this.getMaxSimultaneousWorkers().get() ? 1 : 0) != 0, (String)(" Work is not being done simultaneously enough, only " + this.getMaxSimultaneousWorkers() + "  workers at once. Expecting " + this.getExpectedMaxSimultaneousWorkers() + ". "));
        Assert.assertFalse((this.getExpectedTasksScheduled() != 0 && this.getTasksScheduled().get() < this.getExpectedTasksScheduled() ? 1 : 0) != 0, (String)(" Some tasks are missing, expected " + this.getExpectedTasksScheduled() + " got " + this.getTasksScheduled().get() + ". "));
        Utils.log("Checks passed: tasks: " + this.getTasksScheduled() + "/" + this.getExpectedTasksScheduled() + ", bulkhead: " + this.getMaxSimultaneousWorkers() + "/" + this.getExpectedMaxSimultaneousWorkers());
    }
}

