/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.FutureChecker;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadFutureTest
extends Arquillian {
    private static final int SHORT_TIME = 100;
    private static final int LONG_TIME = 3000;
    @Inject
    private BulkheadMethodAsynchronousDefaultBean bhBeanMethodAsynchronousDefault;
    @Inject
    private BulkheadClassAsynchronousDefaultBean bhBeanClassAsynchronousDefault;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadFutureTest.jar")).addPackage(FutureChecker.class.getPackage())).addClass(Utils.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneAfterGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanMethodAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            String r = (String)result.get();
            Assert.assertTrue((boolean)"GET.".equals(r), (String)r);
            r = (String)result.get(1L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)"GET.GET_TO.".equals(r), (String)r);
        }
        catch (Throwable t) {
            Assert.assertNull((Object)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }

    @Test
    public void testBulkheadMethodAsynchFutureDoneWithoutGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanMethodAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            Thread.sleep(200L);
            int loops = 0;
            while (!result.isDone() && loops++ < 100) {
                Thread.sleep(100L);
            }
        }
        catch (Throwable t) {
            Assert.assertNull((Object)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneAfterGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanClassAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            String r = (String)result.get(1L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)"GET_TO.".equals(r), (String)r);
            r = (String)result.get();
            Assert.assertTrue((boolean)"GET_TO.GET.".equals(r), (String)r);
        }
        catch (Throwable t) {
            Assert.assertNull((Object)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }

    @Test
    public void testBulkheadClassAsynchFutureDoneWithoutGet() {
        FutureChecker fc = new FutureChecker(100);
        Future result = null;
        try {
            result = this.bhBeanMethodAsynchronousDefault.test(fc);
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Assert.assertFalse((boolean)result.isDone(), (String)"Future reporting Done when not");
        try {
            Thread.sleep(200L);
            int loops = 0;
            while (!result.isDone() && loops++ < 100) {
                Thread.sleep(100L);
            }
        }
        catch (Throwable t) {
            Assert.assertNull((Object)t);
        }
        Assert.assertTrue((boolean)result.isDone(), (String)"Future done not reporting true");
    }
}

