/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClassLevelClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class AsynchronousCSTest
extends Arquillian {
    @Inject
    private AsyncClient client;
    @Inject
    private AsyncClassLevelClient clientClass;
    private List<CompletableFuture<Void>> waitingFutures = new ArrayList<CompletableFuture<Void>>();

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsynchronous.jar")).addClasses(new Class[]{AsyncClient.class, AsyncClassLevelClient.class, Connection.class, CompletableFutureHelper.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsynchronous.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAsyncIsNotFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.client.serviceCS(waitingFuture);
        Assert.assertFalse((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        this.complete(waitingFuture);
        try {
            AsynchronousCSTest.waitUntilCompleted(resultFuture);
        }
        catch (CompletionException e) {
            this.handleCompletionException(e);
        }
    }

    @Test
    public void testAsyncIsFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.client.serviceCS(waitingFuture);
        this.complete(waitingFuture);
        Assert.assertTrue((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        try {
            AsynchronousCSTest.waitUntilCompleted(resultFuture);
        }
        catch (CompletionException e) {
            this.handleCompletionException(e);
        }
    }

    @Test
    public void testClassLevelAsyncIsNotFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.clientClass.serviceCS(waitingFuture);
        Assert.assertFalse((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        this.complete(waitingFuture);
        try {
            AsynchronousCSTest.waitUntilCompleted(resultFuture);
        }
        catch (CompletionException e) {
            this.handleCompletionException(e);
        }
    }

    @Test
    public void testClassLevelAsyncIsFinished() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.clientClass.serviceCS(waitingFuture);
        this.complete(waitingFuture);
        Assert.assertTrue((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        try {
            AsynchronousCSTest.waitUntilCompleted(resultFuture);
        }
        catch (CompletionException e) {
            this.handleCompletionException(e);
        }
    }

    @Test
    public void testAsyncCallbacksChained() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        StringBuilder executionRecord = new StringBuilder();
        CompletableFuture<EmptyConnection> innerFuture = new CompletableFuture<EmptyConnection>();
        CompletionStage returnedFuture = innerFuture.thenApply(v -> {
            executionRecord.append("1");
            return v;
        });
        CompletionStage<Connection> resultFuture = this.client.serviceCS(waitingFuture, returnedFuture).thenApply(v -> {
            executionRecord.append("2");
            return v;
        });
        this.complete(waitingFuture);
        resultFuture = resultFuture.thenApply(v -> {
            executionRecord.append("3");
            return v;
        });
        Assert.assertFalse((boolean)AsynchronousCSTest.completesQuickly(resultFuture), (String)"Stage returned by the method isn't completed yet so also the outer stage mustn't be completed");
        innerFuture.complete(new EmptyConnection());
        Assert.assertTrue((boolean)AsynchronousCSTest.completesQuickly(resultFuture), (String)"Stage returned by the method is completed so also the outer stage must be completed");
        Assert.assertEquals((String)executionRecord.toString(), (String)"123", (String)"The execution didn't happen in the expected order");
        try {
            AsynchronousCSTest.waitUntilCompleted(resultFuture);
        }
        catch (CompletionException e) {
            this.handleCompletionException(e);
        }
    }

    @Test
    public void testAsyncCompletesExceptionallyWhenExceptionThrown() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.client.serviceCS(waitingFuture, true);
        waitingFuture.completeExceptionally(new SimulatedException("completedExceptionally"));
        Assert.assertTrue((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        Assert.assertTrue((boolean)AsynchronousCSTest.isCompletedExceptionally(resultFuture));
        Assert.assertFalse((boolean)AsynchronousCSTest.isCancelled(resultFuture));
        AsynchronousCSTest.assertThrowsExecutionExceptionWithCause(SimulatedException.class, CompletableFutureHelper.toCompletableFuture(resultFuture)::get);
    }

    @Test
    public void testAsyncCompletesExceptionallyWhenCompletedExceptionally() {
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        CompletionStage<Connection> resultFuture = this.client.serviceCS(waitingFuture, false);
        waitingFuture.completeExceptionally(new SimulatedException("completedExceptionally"));
        Assert.assertTrue((boolean)AsynchronousCSTest.completesQuickly(resultFuture));
        Assert.assertTrue((boolean)AsynchronousCSTest.isCompletedExceptionally(resultFuture));
        Assert.assertFalse((boolean)AsynchronousCSTest.isCancelled(resultFuture));
        AsynchronousCSTest.assertThrowsExecutionExceptionWithCause(SimulatedException.class, CompletableFutureHelper.toCompletableFuture(resultFuture)::get);
    }

    @AfterMethod
    public void completeWaitingFutures() {
        this.waitingFutures.forEach(future -> future.complete(null));
        this.waitingFutures.clear();
    }

    private CompletableFuture<Void> newWaitingFuture() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.waitingFutures.add(result);
        return result;
    }

    private void complete(CompletableFuture<?> future) {
        future.complete(null);
    }

    private void handleCompletionException(CompletionException e) throws AssertionError {
        throw new AssertionError("testAsync: unexpected Exception calling service: " + e.getCause().getMessage(), e);
    }

    private static Connection waitUntilCompleted(CompletionStage<Connection> resultFuture) {
        return CompletableFutureHelper.toCompletableFuture(resultFuture).join();
    }

    private static boolean completesQuickly(CompletionStage<Connection> resultFuture) {
        try {
            CompletableFutureHelper.toCompletableFuture(resultFuture).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean isCancelled(CompletionStage<Connection> resultFuture) {
        return CompletableFutureHelper.toCompletableFuture(resultFuture).isCancelled();
    }

    private static boolean isCompletedExceptionally(CompletionStage<Connection> resultFuture) {
        return CompletableFutureHelper.toCompletableFuture(resultFuture).isCompletedExceptionally();
    }

    private static void assertThrowsExecutionExceptionWithCause(Class<? extends Throwable> causeClazz, Assert.ThrowingRunnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"ExecutionException not thrown");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)causeClazz.isInstance(ex.getCause()), (String)("Cause of ExecutionException was " + ex.getCause()));
        }
        catch (Throwable ex) {
            Assert.fail((String)"Unexpected exception thrown", (Throwable)ex);
        }
    }

    private static class EmptyConnection
    implements Connection {
        private EmptyConnection() {
        }

        @Override
        public String getData() {
            return null;
        }
    }

    private static class SimulatedException
    extends RuntimeException {
        public SimulatedException() {
        }

        public SimulatedException(String message) {
            super(message);
        }
    }
}

