/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.TimeoutMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricComparator;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class TimeoutMetricTest
extends Arquillian {
    @Inject
    private TimeoutMetricBean timeoutBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricTimeout.war")).addClasses(new Class[]{TimeoutMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testTimeoutMetric() {
        MetricGetter m = new MetricGetter(TimeoutMetricBean.class, "counterTestWorkForMillis");
        m.baselineCounters();
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(2000));
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(2000));
        this.timeoutBean.counterTestWorkForMillis(100);
        MatcherAssert.assertThat((String)"calls timed out", (Object)m.getTimeoutCallsTimedOutDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"calls not timed out", (Object)m.getTimeoutCallsNotTimedOutDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testTimeoutHistogram() {
        MetricGetter m = new MetricGetter(TimeoutMetricBean.class, "histogramTestWorkForMillis");
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(100);
        this.timeoutBean.histogramTestWorkForMillis(1000);
        this.timeoutBean.histogramTestWorkForMillis(1000);
        Exceptions.expectTimeout(() -> this.timeoutBean.histogramTestWorkForMillis(5000));
        Exceptions.expectTimeout(() -> this.timeoutBean.histogramTestWorkForMillis(5000));
        Histogram histogram = m.getTimeoutExecutionDuration().get();
        Snapshot snapshot = histogram.getSnapshot();
        MatcherAssert.assertThat((String)"Histogram count", (Object)histogram.getCount(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"Median", (Object)snapshot.getMedian(), MetricComparator.approxMillis(100L));
        MatcherAssert.assertThat((String)"75th percentile", (Object)snapshot.get75thPercentile(), MetricComparator.approxMillis(1000L));
        MatcherAssert.assertThat((String)"99th percentile", (Object)snapshot.get99thPercentile(), MetricComparator.approxMillis(2000L));
        MatcherAssert.assertThat((String)"99.9th percentile", (Object)snapshot.get999thPercentile(), MetricComparator.approxMillis(2000L));
    }
}

