/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;

public class FutureChecker
extends Checker {
    public FutureChecker(int sleepMillis, TestData td) {
        super(sleepMillis, td);
    }

    public FutureChecker(int sleepMillis) {
        super(sleepMillis, new TestData());
    }

    @Override
    public Future<String> perform() throws InterruptedException {
        block4: {
            try {
                int left = this.getSleep();
                int tick = 250;
                while (left > 0 && !Thread.currentThread().isInterrupted()) {
                    if (left < tick) {
                        Utils.log("tick(" + left + "),");
                        Utils.sleep(left);
                        left = 0;
                        continue;
                    }
                    Utils.log("tick(" + left + "),");
                    Thread.sleep(tick);
                    left -= tick;
                }
            }
            catch (InterruptedException e) {
                Utils.log("FutureChecker interrupted " + e.toString());
                if (this.getSleep() <= 60000) break block4;
                throw e;
            }
        }
        return new TestFuture();
    }

    public final class TestFuture
    implements Future<String> {
        private AtomicBoolean done = new AtomicBoolean(false);
        private String result = "";
        private boolean isCancelCalled;
        private boolean isDoneCalled;
        private boolean isIsCancelledCalled;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelCalled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            this.isIsCancelledCalled = true;
            return this.isCancelCalled;
        }

        @Override
        public boolean isDone() {
            this.isDoneCalled = true;
            return true;
        }

        @Override
        public String get() throws InterruptedException, ExecutionException {
            this.result = this.result + "GET.";
            Utils.log("Result is " + this.result);
            return this.result;
        }

        @Override
        public String get(long timeout, TimeUnit unit) {
            this.result = this.result + "GET_TO.";
            Utils.log("Result is " + this.result);
            return this.result;
        }
    }
}

