/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.timeout.clientserver;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.testng.Assert;

@RequestScoped
public class UninterruptableTimeoutClient {
    private AtomicInteger timeoutAsyncBulkheadCounter = new AtomicInteger();
    private AtomicInteger timeoutAsyncRetryCounter = new AtomicInteger();

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    public void serviceTimeout(int waitMs) {
        long waitNs = Duration.ofMillis(waitMs).toNanos();
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime <= waitNs) {
        }
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    public Future<Void> serviceTimeoutAsync(Future<?> waitingFuture, CompletableFuture<Void> completion) {
        while (true) {
            try {
                waitingFuture.get();
                completion.complete(null);
                return CompletableFuture.completedFuture(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Waiting future threw exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    public CompletionStage<Void> serviceTimeoutAsyncCS(long waitMs) {
        long waitNs = Duration.ofMillis(waitMs).toNanos();
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime <= waitNs) {
        }
        return CompletableFuture.completedFuture(null);
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    @Bulkhead(value=1, waitingTaskQueue=1)
    public Future<Void> serviceTimeoutAsyncBulkhead(Future<?> waitingFuture) {
        this.timeoutAsyncBulkheadCounter.incrementAndGet();
        while (true) {
            try {
                waitingFuture.get();
                return CompletableFuture.completedFuture(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Waiting future threw exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public int getTimeoutAsyncBulkheadCounter() {
        return this.timeoutAsyncBulkheadCounter.get();
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    @Bulkhead(value=1, waitingTaskQueue=1)
    public Future<Void> serviceTimeoutAsyncBulkheadQueueTimed(Future<?> waitingFuture) {
        while (true) {
            try {
                waitingFuture.get();
                return CompletableFuture.completedFuture(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Waiting future threw exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    @Retry(maxRetries=2, delay=0L, jitter=0L)
    public Future<Void> serviceTimeoutAsyncRetry(Future<?> waitingFuture) {
        this.timeoutAsyncRetryCounter.incrementAndGet();
        while (true) {
            try {
                waitingFuture.get();
                return CompletableFuture.completedFuture(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Waiting future threw exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public int getTimeoutAsyncRetryCounter() {
        return this.timeoutAsyncRetryCounter.get();
    }

    @Timeout(value=500L, unit=ChronoUnit.MILLIS)
    @Asynchronous
    @Fallback(fallbackMethod="fallback")
    public Future<String> serviceTimeoutAsyncFallback(Future<?> waitingFuture) {
        while (true) {
            try {
                waitingFuture.get();
                return CompletableFuture.completedFuture("OK");
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException e) {
                Assert.fail((String)"Waiting future threw exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public Future<String> fallback(Future<?> waitingFuture) {
        return CompletableFuture.completedFuture("FALLBACK");
    }
}

