/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config.clientserver;

import java.sql.Connection;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class ConfigClient {
    private int counterForInvokingConnenectionService = 0;
    private int counterForInvokingWritingService = 0;

    @Retry(maxRetries=5)
    public Connection serviceA() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.connectionService();
    }

    @Retry(maxRetries=90, maxDuration=3000L)
    public void serviceC() {
        this.writingService();
    }

    private Connection connectionService() {
        ++this.counterForInvokingConnenectionService;
        throw new RuntimeException("Connection failed");
    }

    public int getCounterForInvokingConnectionService() {
        return this.counterForInvokingConnenectionService;
    }

    private void writingService() {
        ++this.counterForInvokingWritingService;
        try {
            Thread.sleep(100L);
            throw new RuntimeException("WritingService failed");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public int getRetryCountForWritingService() {
        return this.counterForInvokingWritingService;
    }
}

