/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.testng.Assert;

public class Utils {
    private static long tid() {
        return Thread.currentThread().getId();
    }

    static void handleResults(int number, Future[] results) {
        for (int i = 0; i < number; ++i) {
            try {
                Object result = results[i].get();
                if (!(result instanceof Future)) continue;
                result = ((Future)result).get();
                continue;
            }
            catch (Exception e) {
                Assert.fail((String)("Error reported from result " + i), (Throwable)e);
            }
        }
    }

    public static Future[] loop(int iterations, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasksScheduled, TestData td) {
        Future[] results = new Future[iterations];
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(iterations);
        td.setExpectedTasksScheduled(expectedTasksScheduled);
        try {
            for (int i = 0; i < iterations; ++i) {
                Utils.log("Starting test " + i);
                results[i] = test.test(new Checker(1000, td));
            }
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        return results;
    }

    public static void log(String s) {
        System.out.println(Utils.tid() + " " + Utils.hms() + ": " + s);
    }

    private static String hms() {
        return DateTimeFormatter.ofPattern("HH:mm:ss:SS").format(LocalDateTime.now());
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Utils.log("woken" + e.getMessage());
        }
    }

    private Utils() {
    }
}

