/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClassLevelClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncClient;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsynchronousTest
extends Arquillian {
    @Inject
    private AsyncClient client;
    @Inject
    private AsyncClassLevelClient clientClass;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsynchronous.jar")).addClasses(new Class[]{AsyncClient.class, AsyncClassLevelClient.class, Connection.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsynchronous.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAsyncIsNotFinished() {
        Future<Connection> future = null;
        try {
            future = this.client.service();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsync: unexpected InterruptedException calling service");
        }
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testAsyncIsFinished() {
        Future<Connection> future = null;
        try {
            future = this.client.service();
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsync: unexpected InterruptedException calling service");
        }
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testClassLevelAsyncIsNotFinished() {
        Future<Connection> future = null;
        try {
            future = this.clientClass.service();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsync: unexpected InterruptedException calling service");
        }
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testClassLevelAsyncIsFinished() {
        Future<Connection> future = null;
        try {
            future = this.clientClass.service();
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsync: unexpected InterruptedException calling service");
        }
        Assert.assertTrue((boolean)future.isDone());
    }
}

