/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import java.sql.Connection;
import java.time.temporal.ChronoUnit;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class RetryClientForMaxRetries {
    private int counterForInvokingConnenectionService;
    private int counterForInvokingWritingService;
    private int counterForInvokingServiceA;
    private int counterForInvokingServiceB;
    private int counterForInvokingServiceC;

    @Retry(maxRetries=5)
    public Connection serviceA() {
        ++this.counterForInvokingServiceA;
        return this.connectionService();
    }

    private Connection connectionService() {
        ++this.counterForInvokingConnenectionService;
        throw new RuntimeException("Connection failed");
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }

    @Retry(maxRetries=90, maxDuration=1000L)
    public void serviceB() {
        ++this.counterForInvokingServiceB;
        this.writingService();
    }

    @Retry(maxRetries=90, maxDuration=1L, durationUnit=ChronoUnit.SECONDS)
    public void serviceC() {
        ++this.counterForInvokingServiceC;
        this.writingService();
    }

    private void writingService() {
        ++this.counterForInvokingWritingService;
        try {
            Thread.sleep(100L);
            throw new RuntimeException("WritingService failed");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public int getRetryCountForWritingService() {
        return this.counterForInvokingWritingService;
    }

    public int getRetryCounterForServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getRetryCounterForServiceB() {
        return this.counterForInvokingServiceB;
    }

    public int getRetryCounterForServiceC() {
        return this.counterForInvokingServiceC;
    }
}

