/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10ClassSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5ClassSynchronousRetry12Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5MethodSynchronousRetry20Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5RapidRetry0MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead5RapidRetry12MethodSynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.ParrallelBulkheadTest;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadSynchRetryTest
extends Arquillian {
    private static final int DONT_CHECK = 0;
    private static final int THREADPOOL_SIZE = 30;
    private ExecutorService xService = Executors.newFixedThreadPool(30);
    @Inject
    private Bulkhead5MethodSynchronousRetry20Bean methodBean;
    @Inject
    private Bulkhead5ClassSynchronousRetry12Bean classBean;
    @Inject
    private Bulkhead55RapidRetry10MethodSynchBean rrMethodBean;
    @Inject
    private Bulkhead55RapidRetry10ClassSynchBean rrClassBean;
    @Inject
    private Bulkhead5RapidRetry0MethodSynchBean zeroRetryBean;
    @Inject
    private Bulkhead5RapidRetry12MethodSynchBean zeroRetryWaitingQueueBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadSynchRetryTest.jar")).addPackage(Bulkhead5ClassSynchronousRetry12Bean.class.getPackage())).addClass(Utils.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadSynchRetryTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassSynchronousPassiveRetry55() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(threads));
        this.threads(threads, this.classBean, maxSimultaneousWorkers, threads, td);
        td.check();
    }

    @Test
    public void testBulkheadRetriedMethodDueToFailures() {
        int threads = 10;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setLatch(null);
        Future[] results = new Future[threads];
        td.setMaxFill(false);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.xService.submit(new ParrallelBulkheadTest((BulkheadTestBackend)this.rrMethodBean, failOnce));
        }
        Utils.handleResults(threads, results);
        td.check();
    }

    @Test
    public void testBulkheadRetriedClassDueToFailures() {
        int threads = 10;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setLatch(null);
        Future[] results = new Future[threads];
        td.setMaxFill(false);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.xService.submit(new ParrallelBulkheadTest((BulkheadTestBackend)this.rrClassBean, failOnce));
        }
        Utils.handleResults(threads, results);
        td.check();
    }

    @Test
    public void testBulkheadMethodSynchronousRetry55() {
        int threads = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(20));
        this.threads(threads, this.methodBean, maxSimultaneousWorkers, threads, td);
        td.check();
    }

    @Test
    public void testBulkheadPassiveRetryMethodSynchronous55() {
        int threads = 5;
        int maxSimultaneousWorkers = 5;
        int expectedTasks = threads;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.methodBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testBulkheadRetryClassSynchronous55() {
        int threads = 20;
        int expectedTasks = 15;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.classBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testNoRetriesBulkhead() {
        int threads = 30;
        int maxSimultaneousWorkers = 5;
        int expectedTasks = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.zeroRetryBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    @Test
    public void testIgnoreWaitingTaskQueueBulkhead() {
        int threads = 30;
        int maxSimultaneousWorkers = 5;
        int expectedTasks = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasks));
        this.threads(threads, this.zeroRetryWaitingQueueBean, maxSimultaneousWorkers, expectedTasks, td);
        td.check();
    }

    private void threads(int number, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasks, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(number);
        td.setExpectedTasksScheduled(expectedTasks);
        Future[] results = new Future[number];
        for (int i = 0; i < number; ++i) {
            Utils.log("Starting test " + i);
            results[i] = this.xService.submit(new ParrallelBulkheadTest(test, td));
        }
        Utils.handleResults(number, results);
    }
}

