/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.RetryMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class RetryMetricTest
extends Arquillian {
    @Inject
    private RetryMetricBean retryBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricRetry.war")).addClasses(new Class[]{RetryMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void testRetryMetricSuccessfulImmediately() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineCounters();
        this.retryBean.failSeveralTimes(0);
        MatcherAssert.assertThat((String)"calls succeeded without retry", (Object)m.getRetryCallsSucceededNotRetriedDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"calls succeeded after retry", (Object)m.getRetryCallsSucceededRetriedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls failed", (Object)m.getRetryCallsFailedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetriesDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricSuccessfulAfterRetry() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineCounters();
        this.retryBean.failSeveralTimes(3);
        MatcherAssert.assertThat((String)"calls succeeded without retry", (Object)m.getRetryCallsSucceededNotRetriedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls succeeded after retry", (Object)m.getRetryCallsSucceededRetriedDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"calls failed", (Object)m.getRetryCallsFailedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetriesDelta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricUnsuccessful() {
        MetricGetter m = new MetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineCounters();
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20));
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20));
        MatcherAssert.assertThat((String)"calls succeeded without retry", (Object)m.getRetryCallsSucceededNotRetriedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls succeeded after retry", (Object)m.getRetryCallsSucceededRetriedDelta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"calls failed", (Object)m.getRetryCallsFailedDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetriesDelta(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"invocations", (Object)m.getInvocationsDelta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocationsFailedDelta(), (Matcher)Matchers.is((Object)2L));
    }
}

