/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class RetryClientWithDelay {
    private int counterForInvokingConnenectionService;
    private long timestampForConnectionService = 0L;
    private Set<Long> delayTimes = new HashSet<Long>();

    @Retry(delay=400L, maxDuration=3200L, jitter=400L, maxRetries=10)
    public Connection serviceA() {
        return this.connectionService();
    }

    private Connection connectionService() {
        if (this.timestampForConnectionService != 0L) {
            long currentTime = System.currentTimeMillis();
            this.delayTimes.add(currentTime - this.timestampForConnectionService);
            this.timestampForConnectionService = currentTime;
        }
        ++this.counterForInvokingConnenectionService;
        throw new RuntimeException("Connection failed");
    }

    public boolean isDelayInRange() {
        boolean isDelayInRange = true;
        for (long delayTime : this.delayTimes) {
            if (delayTime <= 800L) continue;
            return false;
        }
        return isDelayInRange;
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }
}

