/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55ClassAsynchronousRetryBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55MethodAsynchronousRetryBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10ClassAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead55RapidRetry10MethodAsynchBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.ParrallelBulkheadTest;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadAsynchRetryTest
extends Arquillian {
    private static final int DONT_CHECK = 0;
    private static final int THREADPOOL_SIZE = 30;
    private ExecutorService xService = Executors.newFixedThreadPool(30);
    @Inject
    private Bulkhead55MethodAsynchronousRetryBean methodBean;
    @Inject
    private Bulkhead55ClassAsynchronousRetryBean classBean;
    @Inject
    private Bulkhead55RapidRetry10ClassAsynchBean rrClassBean;
    @Inject
    private Bulkhead55RapidRetry10MethodAsynchBean rrMethodBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchRetryTest.jar")).addPackage(Bulkhead55ClassAsynchronousRetryBean.class.getPackage())).addClass(Utils.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchRetryTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassAsynchronousPassiveRetry55() {
        int iterations;
        int expectedTasksScheduled = iterations = 10;
        TestData td = new TestData(new CountDownLatch(expectedTasksScheduled));
        Utils.loop(iterations, this.classBean, 5, expectedTasksScheduled, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousRetry55() {
        int iterations;
        int expectedTasksScheduled = iterations = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasksScheduled));
        Utils.loop(iterations, this.methodBean, maxSimultaneousWorkers, expectedTasksScheduled, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousRetry55Trip() throws InterruptedException {
        boolean tripped;
        int iterations = 11;
        int maxSimultaneousWorkers = 5;
        CountDownLatch latch = new CountDownLatch(10);
        TestData td = new TestData(latch);
        try {
            Utils.loop(iterations, this.rrMethodBean, maxSimultaneousWorkers, 0, td);
            tripped = false;
        }
        catch (BulkheadException bhe) {
            tripped = true;
            Utils.log("Class Bulkhead queue not long enough as expected " + bhe.getMessage());
        }
        Assert.assertTrue((tripped || latch.getCount() < 10L ? 1 : 0) != 0, (String)"Asynchronous class Bulkead Retry not throwing Bulkhead exception when retry limit just exceeded");
        td.setExpectedTasksScheduled(0);
        td.setExpectedInstances(0);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronous55RetryOverload() throws InterruptedException {
        boolean blown;
        int iterations = 1000;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        try {
            Utils.loop(iterations, this.rrMethodBean, maxSimultaneousWorkers, 0, td);
            blown = false;
        }
        catch (BulkheadException bhe) {
            blown = true;
            Utils.log("Method Bulkhead blown as expected " + bhe.getMessage());
        }
        Assert.assertTrue((boolean)blown, (String)"Asynchronous method Bulkead Retry not throwing Bulkhead exception when retry limit exceeded");
    }

    @Test
    public void testBulkheadClassAsynchronous55RetryOverload() {
        boolean blown;
        int iterations;
        int expectedTasksScheduled = iterations = 1000;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData();
        try {
            Utils.loop(iterations, this.rrClassBean, maxSimultaneousWorkers, expectedTasksScheduled, td);
            blown = false;
        }
        catch (BulkheadException bhe) {
            blown = true;
            Utils.log("Class Bulkhead blown as expected " + bhe.getMessage());
        }
        Assert.assertTrue((boolean)blown, (String)"Asynchronous class Bulkead Retry not throwing Bulkhead exception when retry limit exceeded");
    }

    @Test
    public void testBulkheadPassiveRetryMethodAsynchronous55() {
        int iterations;
        int expectedTasksScheduled = iterations = 10;
        TestData td = new TestData(new CountDownLatch(expectedTasksScheduled));
        Utils.loop(iterations, this.methodBean, 5, expectedTasksScheduled, td);
        td.check();
    }

    @Test
    public void testBulkheadRetryClassAsynchronous55() {
        int iterations;
        int expectedTasksScheduled = iterations = 20;
        int maxSimultaneousWorkers = 5;
        TestData td = new TestData(new CountDownLatch(expectedTasksScheduled));
        Utils.loop(iterations, this.classBean, maxSimultaneousWorkers, expectedTasksScheduled, td);
        td.check();
    }

    @Test
    public void testBulkheadQueReplacesDueToClassRetryFailures() {
        int threads = 10;
        int maxSimultaneousWorkers = 5;
        Future[] results = new Future[threads];
        TestData td = new TestData(new CountDownLatch(threads));
        td.setExpectedInstances(threads);
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setMaxFill(false);
        td.setExpectedTasksScheduled(0);
        for (int i = 0; i < threads; ++i) {
            Utils.log("Starting test " + i);
            Checker failOnce = new Checker(100, td, 1);
            results[i] = this.xService.submit(new ParrallelBulkheadTest((BulkheadTestBackend)this.rrClassBean, failOnce));
        }
        td.check();
        Utils.handleResults(threads, results);
    }
}

