/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientAbortOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientRetryOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientAbortOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientRetryOn;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryConditionTest
extends Arquillian {
    @Inject
    private RetryClientRetryOn clientForRetryOn;
    @Inject
    private RetryClientAbortOn clientForAbortOn;
    @Inject
    private RetryClassLevelClientRetryOn clientForClassLevelRetryOn;
    @Inject
    private RetryClassLevelClientAbortOn clientForClassLevelAbortOn;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryCondition.jar")).addClasses(new Class[]{RetryClientAbortOn.class, RetryClientRetryOn.class, RetryClassLevelClientRetryOn.class, RetryClassLevelClientAbortOn.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryCondition.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryOnTrue() {
        try {
            this.clientForRetryOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testRetryOnFalse() {
        try {
            this.clientForRetryOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testRetryOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the retry condition is false");
    }

    @Test
    public void testRetryWithAbortOnFalse() {
        try {
            this.clientForAbortOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryWithAbortOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForAbortOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testRetryWithAbortOnTrue() {
        try {
            this.clientForAbortOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testRetryWithAbortOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForAbortOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the abort condition is true");
    }

    @Test
    public void testClassLevelRetryOnTrue() {
        try {
            this.clientForClassLevelRetryOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelRetryOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelRetryOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testClassLevelRetryOnFalse() {
        try {
            this.clientForClassLevelRetryOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelRetryOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelRetryOn.getRetryCountForWritingService(), (int)1, (String)"The execution count should be 1 as the retry condition is false");
    }

    @Test
    public void testClassLevelRetryWithAbortOnFalse() {
        try {
            this.clientForClassLevelAbortOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelRetryWithAbortOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelAbortOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testClassLevelRetryWithAbortOnTrue() {
        try {
            this.clientForClassLevelAbortOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelRetryWithAbortOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelAbortOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the abort condition is true");
    }
}

