/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.testng.Assert;

public class Exceptions {
    private Exceptions() {
    }

    public static void expectTimeout(ExceptionThrowingAction action) {
        Exceptions.expect(TimeoutException.class, action);
    }

    public static void expectTestException(ExceptionThrowingAction action) {
        Exceptions.expect(TestException.class, action);
    }

    public static void expectCbOpen(ExceptionThrowingAction action) {
        Exceptions.expect(CircuitBreakerOpenException.class, action);
    }

    public static void expectBulkheadException(ExceptionThrowingAction action) {
        Exceptions.expect(BulkheadException.class, action);
    }

    public static void expectBulkheadException(Future<?> future) {
        Exceptions.expect(BulkheadException.class, future);
    }

    public static void expect(Class<? extends Exception> expectedException, Future<?> future) {
        try {
            future.get();
            Assert.fail((String)"Execution exception not thrown from Future");
        }
        catch (ExecutionException e) {
            if (!expectedException.isInstance(e.getCause())) {
                Assert.fail((String)"Unexpected exception thrown from Future", (Throwable)e.getCause());
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Getting future result was interrupted", (Throwable)e);
        }
    }

    public static void expect(Class<? extends Exception> expectedException, ExceptionThrowingAction action) {
        block2: {
            try {
                action.call();
                Assert.fail((String)("Expected exception not thrown. Expected " + expectedException.getName()));
            }
            catch (Exception e) {
                if (expectedException.isInstance(e)) break block2;
                Assert.fail((String)"Unexpected exception thrown", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface ExceptionThrowingAction {
        public void call() throws Exception;
    }
}

