/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.util.ConcurrentExecutionTracker;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

@ApplicationScoped
public class BulkheadMetricBean {
    @Inject
    private ConcurrentExecutionTracker tracker;

    @Bulkhead(value=2)
    public void waitFor(Future<?> future) {
        this.doWaitFor(future);
    }

    @Bulkhead(value=2)
    public void waitForHistogram(Future<?> future) {
        this.doWaitFor(future);
    }

    @Asynchronous
    @Bulkhead(value=2, waitingTaskQueue=2)
    public Future<Void> waitForAsync(Future<?> future) {
        this.doWaitFor(future);
        return CompletableFuture.completedFuture(null);
    }

    private void doWaitFor(Future<?> future) {
        try {
            this.tracker.executionStarted();
            future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Test was interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Passed Future threw an exception", e);
        }
        finally {
            this.tracker.executionEnded();
        }
    }

    public void waitForRunningExecutions(int executions) {
        this.tracker.waitForRunningExecutions(executions);
    }
}

