/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.disableEnv.DisableClient;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.StringFallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DisableTest
extends Arquillian {
    @Inject
    private DisableClient disableClient;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftDisableAllButFallback.jar")).addClasses(new Class[]{DisableClient.class, StringFallbackHandler.class})).addAsManifestResource((Asset)new StringAsset("MP_Fault_Tolerance_NonFallback_Enabled=false"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftDisableAllButFallback.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryDisabled() {
        try {
            this.disableClient.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryDisabled");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.disableClient.getRetryCountForConnectionService(), (int)1, (String)"The max number of executions should be 1");
    }

    @Test
    public void testFallbackSuccess() {
        try {
            String result = this.disableClient.serviceB();
            System.out.println("testFallbackSuccess got result - " + result);
            Assert.assertTrue((boolean)result.contains("serviceB"), (String)"The message should be \"fallback for serviceB\"");
        }
        catch (RuntimeException ex) {
            Assert.fail((String)"serviceB should not throw a RuntimeException in testFallbackSuccess");
        }
        Assert.assertEquals((int)this.disableClient.getCounterForInvokingServiceB(), (int)1, (String)"The execution count should be 1 (0 retries + 1)");
    }

    @Test
    public void testCircuitClosedThenOpen() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.disableClient.serviceC();
                continue;
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceC should throw a RuntimeException in testCircuitClosedThenOpen on iteration " + i + " but caught exception " + ex));
            }
        }
        int serviceCExecutions = this.disableClient.getCounterForInvokingServiceC();
        Assert.assertEquals((int)serviceCExecutions, (int)7, (String)"The number of executions should be 7");
    }

    @Test
    public void testTimeout() {
        try {
            this.disableClient.serviceD(3000L);
            Assert.fail((String)"serviceD should throw a TimeoutException in testTimeout");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceD should throw a RuntimeException in testTimeout not a TimeoutException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

