/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10ClassSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10MethodSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3ClassSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3MethodSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassSemaphoreDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodSemaphoreDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.ParrallelBulkheadTest;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadSynchTest
extends Arquillian {
    private static final int THREADPOOL_SIZE = 30;
    private ExecutorService xService = Executors.newFixedThreadPool(30);
    @Inject
    private BulkheadClassSemaphoreDefaultBean bhBeanClassSemaphoreDefault;
    @Inject
    private BulkheadMethodSemaphoreDefaultBean bhBeanMethodSemaphoreDefault;
    @Inject
    private Bulkhead3ClassSemaphoreBean bhBeanClassSemaphore3;
    @Inject
    private Bulkhead3MethodSemaphoreBean bhBeanMethodSemaphore3;
    @Inject
    private Bulkhead10ClassSemaphoreBean bhBeanClassSemaphore10;
    @Inject
    private Bulkhead10MethodSemaphoreBean bhBeanMethodSemaphore10;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadSynchTest.jar")).addPackage(BulkheadClassSemaphoreDefaultBean.class.getPackage())).addClass(Utils.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadSynchTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassSemaphore3() {
        TestData td = new TestData(new CountDownLatch(3));
        this.threads(20, this.bhBeanClassSemaphore3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadClassSemaphore10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.threads(20, this.bhBeanClassSemaphore10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodSemaphore10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.threads(20, this.bhBeanMethodSemaphore10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodSemaphore3() {
        TestData td = new TestData(new CountDownLatch(3));
        this.threads(20, this.bhBeanMethodSemaphore3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadClassSemaphoreDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.threads(20, this.bhBeanClassSemaphoreDefault, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodSemaphoreDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.threads(20, this.bhBeanMethodSemaphoreDefault, 10, td);
        td.check();
    }

    private void threads(int number, BulkheadTestBackend test, int maxSimultaneousWorkers, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(number);
        Future[] results = new Future[number];
        for (int i = 0; i < number; ++i) {
            Utils.log("Starting test " + i);
            results[i] = this.xService.submit(new ParrallelBulkheadTest(test, td));
        }
        Utils.handleResults(number, results);
    }
}

